/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.google.firestore.data;

import com.dbeaver.db.google.firestore.exec.FireStoreSession;
import com.dbeaver.db.google.firestore.model.FireStoreCollection;
import com.dbeaver.db.google.firestore.model.FireStoreDatasource;
import com.dbeaver.model.document.data.DBAbstractDocument;
import com.dbeaver.model.document.data.DBCDocumentHierarchical;
import com.dbeaver.model.document.data.DBMapValue;
import com.google.cloud.Date;
import com.google.cloud.firestore.CollectionReference;
import com.google.cloud.firestore.Firestore;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDValueCloneable;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.meta.MetaData;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class FireStoreDocument
extends DBAbstractDocument<FireStoreDatasource, Map<String, Object>>
implements DBDValueCloneable,
DBCDocumentHierarchical<FireStoreCollection> {
    private String id;
    private final Timestamp createTime;
    @Nullable
    private String path;

    public FireStoreDocument(@NotNull FireStoreDatasource dataSource, @Nullable Map<String, Object> data, @Nullable String id, @Nullable String path, @Nullable Timestamp createTime) {
        super((DBPDataSource)dataSource, data);
        this.id = id;
        this.path = path;
        this.createTime = createTime;
    }

    @MetaData(name="documentId")
    @Nullable
    public Object getDocumentId() {
        return this.id;
    }

    @MetaData(name="path")
    @Nullable
    public String getPath() {
        return this.path;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setPath(@Nullable String path) {
        this.path = path;
    }

    @Nullable
    public Object getDocumentProperty(String name) {
        return switch (name) {
            case "id" -> this.getDocumentId();
            case "createTime" -> this.createTime;
            case "idAttributeName" -> this.id;
            default -> null;
        };
    }

    public void serializeDocument(@NotNull DBRProgressMonitor monitor, @NotNull Writer writer) {
        ((FireStoreDatasource)this.dataSource).serializeDocument((Map)this.getRawValue(), writer);
    }

    public void updateDocument(@NotNull DBRProgressMonitor monitor, @NotNull Reader reader) {
        Map<String, Object> stringObjectMap = ((FireStoreDatasource)this.dataSource).deserializeDocument(reader);
        this.rawMap = new DBMapValue((DBPDataSource)((FireStoreDatasource)this.dataSource), (Object)this, stringObjectMap);
        this.rawValue = stringObjectMap;
        this.markModified();
    }

    public DBDValueCloneable cloneValue(DBRProgressMonitor monitor) throws DBCException {
        return this.copy(true);
    }

    protected FireStoreDocument copy(boolean fullCopy) {
        return new FireStoreDocument((FireStoreDatasource)this.dataSource, this.rawValue == null ? null : new HashMap<String, Object>((Map)this.rawValue), fullCopy ? this.id : null, fullCopy ? this.path : null, fullCopy ? this.createTime : null);
    }

    public List<FireStoreCollection> listChildrenEntities(@NotNull DBRProgressMonitor monitor) throws DBCException {
        if (CommonUtils.isEmpty((String)this.path)) {
            return Collections.emptyList();
        }
        return ((FireStoreDatasource)this.dataSource).listChildrenEntities(this.path, monitor, false);
    }

    public void createChildEntity(String name, @NotNull DBRProgressMonitor monitor) throws DBCException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (FireStoreSession session = (FireStoreSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this.dataSource, (String)"Create SubCollection");){
            String collectionPath = this.getPath() + "/" + name;
            session.getExecutionContext().getService().collection(collectionPath).add(new HashMap());
            ((FireStoreDatasource)this.dataSource).getChildrenEntityInstance(collectionPath, monitor, true, false);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void deleteChildEntity(String name, @NotNull DBRProgressMonitor monitor) throws DBCException {
        String collectionPath = this.getPath() + "/" + name;
        Throwable throwable = null;
        Object var5_6 = null;
        try (FireStoreSession session = (FireStoreSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this.dataSource, (String)"Delete SubCollection");){
            Firestore service = session.getExecutionContext().getService();
            CollectionReference collection = service.collection(collectionPath);
            service.recursiveDelete(collection);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ((FireStoreDatasource)this.dataSource).removeChildrenEntity(collectionPath);
    }

    protected DBMapValue<FireStoreDatasource> makeRawMap() {
        return new DBMapValue((DBPDataSource)((FireStoreDatasource)this.dataSource), (Object)this, (Map)this.rawValue);
    }

    public static class DateJsonConverter
    implements JsonSerializer<Date>,
    JsonDeserializer<Date> {
        public JsonElement serialize(Date src, Type srcType, JsonSerializationContext context) {
            return new JsonPrimitive(src.toString());
        }

        public Date deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            return Date.parseDate((String)json.getAsString());
        }
    }

    public static class TimestampJsonConverter
    implements JsonSerializer<com.google.cloud.Timestamp>,
    JsonDeserializer<com.google.cloud.Timestamp> {
        public JsonElement serialize(com.google.cloud.Timestamp src, Type srcType, JsonSerializationContext context) {
            return new JsonPrimitive(src.toString());
        }

        public com.google.cloud.Timestamp deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            return com.google.cloud.Timestamp.parseTimestamp((String)json.getAsString());
        }
    }
}

