/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.yellowbrick;

import com.dbeaver.db.yellowbrick.YellowbrickOAuthCredentials;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.access.DBAAuthModel;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class YellowbrickOAuthModel
implements DBAAuthModel<YellowbrickOAuthCredentials> {
    @NotNull
    public YellowbrickOAuthCredentials createCredentials() {
        return new YellowbrickOAuthCredentials();
    }

    @NotNull
    public YellowbrickOAuthCredentials loadCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration) {
        YellowbrickOAuthCredentials credentials = this.createCredentials();
        credentials.setClientID(configuration.getAuthProperty("oauth2ClientId"));
        credentials.setClientSecret(configuration.getAuthProperty("oauth2ClientSecret"));
        credentials.setIssuer(configuration.getAuthProperty("oauth2Issuer"));
        return credentials;
    }

    public void saveCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull YellowbrickOAuthCredentials credentials) {
        configuration.setAuthProperty("oauth2ClientId", credentials.getClientID());
        configuration.setAuthProperty("oauth2ClientSecret", credentials.getClientSecret());
        configuration.setAuthProperty("oauth2Issuer", credentials.getIssuer());
    }

    public Object initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull YellowbrickOAuthCredentials credentials, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) {
        String clientID = credentials.getClientID();
        String clientSecret = credentials.getClientSecret();
        String issuer = credentials.getIssuer();
        connProperties.put("oauth2Issuer", issuer);
        connProperties.put("oauth2ClientId", clientID);
        if (!CommonUtils.isEmpty((String)clientSecret)) {
            connProperties.put("oauth2ClientSecret", clientSecret);
        }
        return credentials;
    }

    public void endAuthentication(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) {
    }

    public void refreshCredentials(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull YellowbrickOAuthCredentials credentials) {
    }
}

