/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.sybase.model;

import com.dbeaver.db.sybase.model.SybaseMetaModel;
import com.dbeaver.db.sybase.model.SybaseUser;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mssql.model.generic.SQLServerGenericDataSource;
import org.jkiss.dbeaver.ext.mssql.model.generic.SQLServerMetaModel;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectLookupCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class SybaseDataSource
extends SQLServerGenericDataSource {
    private final UserCache userCache = new UserCache();

    public SybaseDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        super(monitor, container, (SQLServerMetaModel)new SybaseMetaModel());
    }

    @Association
    public Collection<SybaseUser> getUsers(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.userCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Association
    public SybaseUser getUser(@NotNull DBRProgressMonitor monitor, @NotNull String name) throws DBException {
        return (SybaseUser)this.userCache.getObject(monitor, (DBSObject)this, name);
    }

    private class UserCache
    extends JDBCObjectLookupCache<SybaseDataSource, SybaseUser> {
        private UserCache() {
        }

        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull SybaseDataSource sybaseDataSource, @Nullable SybaseUser object, @Nullable String objectName) throws SQLException {
            String sql = "SELECT u.*, r.remarks FROM SYS.SYSUSER u LEFT JOIN SYS.SYSREMARK r ON u.object_id = r.object_id" + (object != null || objectName != null ? " WHERE user_name = ?" : "") + " ORDER BY user_name";
            JDBCPreparedStatement statement = session.prepareStatement(sql);
            if (object != null || objectName != null) {
                statement.setString(1, object != null ? object.getName() : objectName);
            }
            return statement;
        }

        @Nullable
        protected SybaseUser fetchObject(@NotNull JDBCSession session, @NotNull SybaseDataSource sybaseDataSource, @NotNull JDBCResultSet resultSet) {
            String userName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"user_name");
            if (CommonUtils.isNotEmpty((String)userName)) {
                return new SybaseUser(sybaseDataSource, userName, resultSet);
            }
            return null;
        }
    }
}

