/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.commands;

import com.dbeaver.ee.vqb.ui.part.QueryJoinPart;
import com.dbeaver.model.sql.vqb.model.VQBUtils;
import java.util.Collections;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.statement.select.Join;
import org.jkiss.dbeaver.model.erd.ERDEntityAttribute;
import org.jkiss.dbeaver.ui.editors.erd.command.AssociationDeleteCommand;
import org.jkiss.dbeaver.ui.editors.erd.part.AssociationPart;

public class QueryJoinDeleteCommand
extends AssociationDeleteCommand {
    private Expression joinExpression;
    private List<ERDEntityAttribute> originalTargetAttributes;
    private List<ERDEntityAttribute> originalSourceAttributes;

    public QueryJoinDeleteCommand(QueryJoinPart part) {
        super((AssociationPart)part);
    }

    public void execute() {
        Join join = (Join)this.association.getUserData();
        if (join != null) {
            this.joinExpression = VQBUtils.getJoinOnExpression((Join)join);
            join.setOnExpressions(Collections.emptyList());
        }
        this.association.setUserData((Object)join);
        List sourceAttributes = this.association.getSourceAttributes();
        this.originalSourceAttributes = List.copyOf(sourceAttributes);
        sourceAttributes.clear();
        List targetAttributes = this.association.getTargetAttributes();
        this.originalTargetAttributes = List.copyOf(targetAttributes);
        targetAttributes.clear();
        this.part.refresh();
        this.part.setSelected(0);
    }

    public void undo() {
        if (this.association != null) {
            Join join = (Join)this.association.getUserData();
            if (VQBUtils.getJoinOnExpression((Join)join) == null) {
                join.setOnExpressions(Collections.singletonList(this.joinExpression));
            }
            this.association.getSourceAttributes().addAll(this.originalSourceAttributes);
            this.association.getTargetAttributes().addAll(this.originalTargetAttributes);
            this.part.refresh();
        }
    }
}

