/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.data.handlers;

import com.dbeaver.db.mongodb.data.handlers.MongoBaseValueHandler;
import com.dbeaver.db.mongodb.exec.MGSession;
import com.dbeaver.db.mongodb.exec.sql.MGCustomStatement;
import java.util.UUID;
import org.bson.types.Binary;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class MongoObjectValueHandler
extends MongoBaseValueHandler {
    public static final MongoObjectValueHandler INSTANCE = new MongoObjectValueHandler();

    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        if (value instanceof UUID) {
            return value.toString();
        }
        return super.getValueDisplayString(column, value, format);
    }

    @NotNull
    public Class<?> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return Object.class;
    }

    @Override
    public Object fetchValueObject(@NotNull DBCSession session, @NotNull DBCResultSet resultSet, @NotNull DBSTypedObject type, int index) throws DBCException {
        Object value = super.fetchValueObject(session, resultSet, type, index);
        return value;
    }

    @Nullable
    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, @Nullable Object object, boolean copy, boolean validateValue) {
        if (object instanceof UUID) {
            object = MongoObjectValueHandler.toStandardBinaryUUID((UUID)object);
        }
        return object;
    }

    @Override
    protected void bindParameter(@NotNull MGSession session, @NotNull MGCustomStatement statement, @NotNull DBSTypedObject paramType, int paramIndex, Object value) throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    public static UUID fromStandardBinaryUUID(Binary binary) {
        long msb = 0L;
        long lsb = 0L;
        byte[] uuidBytes = binary.getData();
        int i = 8;
        while (i < 16) {
            lsb <<= 8;
            lsb |= (long)uuidBytes[i] & 0xFFL;
            ++i;
        }
        i = 0;
        while (i < 8) {
            msb <<= 8;
            msb |= (long)uuidBytes[i] & 0xFFL;
            ++i;
        }
        return new UUID(msb, lsb);
    }

    public static Binary toStandardBinaryUUID(UUID uuid) {
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        byte[] uuidBytes = new byte[16];
        int i = 15;
        while (i >= 8) {
            uuidBytes[i] = (byte)(lsb & 0xFFL);
            lsb >>= 8;
            --i;
        }
        i = 7;
        while (i >= 0) {
            uuidBytes[i] = (byte)(msb & 0xFFL);
            msb >>= 8;
            --i;
        }
        return new Binary(4, uuidBytes);
    }
}

