/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.feedranges;

import com.azure.cosmos.implementation.feedranges.FeedRangeCompositeContinuationImpl;
import com.azure.cosmos.implementation.feedranges.FeedRangeContinuation;
import com.azure.cosmos.implementation.feedranges.FeedRangeInternal;
import com.azure.cosmos.implementation.feedranges.FeedRangeInternalDeserializer;
import com.azure.cosmos.implementation.query.CompositeContinuationToken;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;

public class FeedRangeContinuationDeserializer
extends StdDeserializer<FeedRangeContinuation> {
    private static final long serialVersionUID = 1L;

    public FeedRangeContinuationDeserializer() {
        this(null);
    }

    public FeedRangeContinuationDeserializer(Class<?> vc) {
        super(vc);
    }

    public FeedRangeContinuation deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonNode rootNode = (JsonNode)parser.getCodec().readTree(parser);
        ObjectMapper mapper = (ObjectMapper)parser.getCodec();
        return FeedRangeContinuationDeserializer.deserializeFeedRangeContinuation(rootNode, mapper, parser);
    }

    public static FeedRangeContinuation deserializeFeedRangeContinuation(JsonNode rootNode, ObjectMapper mapper, JsonParser parser) throws JsonMappingException {
        JsonNode versionNode = rootNode.get("V");
        if (versionNode == null || !versionNode.isInt()) {
            throw JsonMappingException.from((JsonParser)parser, (String)String.format("Required property '%s' missing or does not have a valid value.", "V"));
        }
        JsonNode ridNode = rootNode.get("Rid");
        if (ridNode == null || !ridNode.isTextual()) {
            throw JsonMappingException.from((JsonParser)parser, (String)String.format("Required property '%s' missing or does not have a valid value.", "Rid"));
        }
        String containerRid = ridNode.textValue();
        JsonNode continuationNode = rootNode.get("Continuation");
        if (continuationNode == null || !continuationNode.isArray() || continuationNode.size() == 0) {
            throw JsonMappingException.from((JsonParser)parser, (String)String.format("Required property '%s' missing or does not have a valid value.", "Continuation"));
        }
        ArrayList<CompositeContinuationToken> tokens = new ArrayList<CompositeContinuationToken>(continuationNode.size());
        for (int i = 0; i < continuationNode.size(); ++i) {
            JsonNode tokenNode = continuationNode.get(i);
            if (tokenNode == null || !tokenNode.isObject()) {
                throw JsonMappingException.from((JsonParser)parser, (String)String.format("Required property '%s' at index '%d' missing or does not have a valid value.", "Continuation", i));
            }
            tokens.add(new CompositeContinuationToken((ObjectNode)tokenNode));
        }
        FeedRangeInternal feedRange = FeedRangeInternalDeserializer.deserializeFeedRange(rootNode, mapper, parser);
        return FeedRangeCompositeContinuationImpl.createFromDeserializedTokens(containerRid, feedRange, tokens);
    }
}

