/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.feedranges;

import com.azure.cosmos.implementation.GoneException;
import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.RxDocumentClientImpl;
import com.azure.cosmos.implementation.ShouldRetryResult;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.feedranges.FeedRangeCompositeContinuationImpl;
import com.azure.cosmos.implementation.feedranges.FeedRangeContinuationDeserializer;
import com.azure.cosmos.implementation.feedranges.FeedRangeInternal;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.query.CompositeContinuationToken;
import com.azure.cosmos.implementation.routing.Range;
import com.azure.cosmos.models.FeedResponse;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

@JsonDeserialize(using=FeedRangeContinuationDeserializer.class)
public abstract class FeedRangeContinuation
extends JsonSerializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeedRangeContinuation.class);
    protected final FeedRangeInternal feedRange;
    private final String containerRid;

    protected FeedRangeContinuation() {
        this.feedRange = null;
        this.containerRid = null;
    }

    public FeedRangeContinuation(String containerRid, FeedRangeInternal feedRange) {
        Preconditions.checkNotNull(feedRange, "expected non-null feedRange");
        this.feedRange = feedRange;
        this.containerRid = containerRid;
    }

    public String getContainerRid() {
        return this.containerRid;
    }

    public FeedRangeInternal getFeedRange() {
        return this.feedRange;
    }

    public abstract CompositeContinuationToken getCurrentContinuationToken();

    public abstract int getContinuationTokenCount();

    public abstract void replaceContinuation(String var1, boolean var2);

    public abstract boolean isDone();

    public abstract void validateContainer(String var1);

    public abstract CompositeContinuationToken[] getCurrentContinuationTokens();

    public abstract Queue<CompositeContinuationToken> getCompositeContinuationTokens();

    @Override
    public void populatePropertyBag() {
        super.populatePropertyBag();
    }

    private static FeedRangeContinuation tryParse(String jsonString) {
        if (jsonString == null) {
            return null;
        }
        try {
            return FeedRangeCompositeContinuationImpl.parse(jsonString);
        }
        catch (IOException ioError) {
            LOGGER.debug("Failed to parse feed range continuation JSON {}", (Object)jsonString, (Object)ioError);
            return null;
        }
    }

    public static FeedRangeContinuation convert(String continuationToken) {
        if (Strings.isNullOrWhiteSpace(continuationToken)) {
            throw new NullPointerException("continuationToken");
        }
        FeedRangeContinuation returnValue = FeedRangeContinuation.tryParse(continuationToken);
        if (returnValue != null) {
            return returnValue;
        }
        throw new IllegalArgumentException(String.format("Invalid Feed range continuation token '%s'", continuationToken));
    }

    public static FeedRangeContinuation create(String containerRid, FeedRangeInternal feedRange, Range<String> effectiveRange) {
        Preconditions.checkNotNull(containerRid, "Argument 'collectionLink' must not be null");
        Preconditions.checkNotNull(feedRange, "Argument 'feedRange' must not be null");
        Preconditions.checkNotNull(effectiveRange, "Argument 'effectiveRange' must not be null");
        ArrayList<Range<String>> ranges = new ArrayList<Range<String>>();
        ranges.add(effectiveRange);
        return new FeedRangeCompositeContinuationImpl(containerRid, feedRange, ranges, null);
    }

    public static FeedRangeContinuation create(String containerRid, FeedRangeInternal feedRange, List<CompositeContinuationToken> continuationTokens) {
        return new FeedRangeCompositeContinuationImpl(containerRid, feedRange, continuationTokens);
    }

    public abstract <T> ShouldRetryResult handleChangeFeedNotModified(FeedResponse<T> var1);

    public abstract <T> boolean hasFetchedAllChanges(FeedResponse<T> var1, Long var2);

    public abstract Mono<ShouldRetryResult> handleFeedRangeGone(RxDocumentClientImpl var1, GoneException var2);
}

