/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.DiagnosticsClientContext;
import com.azure.cosmos.implementation.DocumentClientRetryPolicy;
import com.azure.cosmos.implementation.DocumentCollection;
import com.azure.cosmos.implementation.Exceptions;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RetryContext;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.ShouldRetryResult;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.caches.IPartitionKeyRangeCache;
import com.azure.cosmos.implementation.caches.RxCollectionCache;
import com.azure.cosmos.implementation.routing.CollectionRoutingMap;
import java.time.Duration;
import java.util.Map;
import reactor.core.publisher.Mono;

public class PartitionKeyRangeGoneRetryPolicy
extends DocumentClientRetryPolicy {
    private final RxCollectionCache collectionCache;
    private final DiagnosticsClientContext diagnosticsClientContext;
    private final DocumentClientRetryPolicy nextRetryPolicy;
    private final IPartitionKeyRangeCache partitionKeyRangeCache;
    private final String collectionLink;
    private final Map<String, Object> requestOptionProperties;
    private volatile boolean retried;
    private RxDocumentServiceRequest request;

    public PartitionKeyRangeGoneRetryPolicy(DiagnosticsClientContext diagnosticsClientContext, RxCollectionCache collectionCache, IPartitionKeyRangeCache partitionKeyRangeCache, String collectionLink, DocumentClientRetryPolicy nextRetryPolicy, Map<String, Object> requestOptionProperties) {
        this.diagnosticsClientContext = diagnosticsClientContext;
        this.collectionCache = collectionCache;
        this.partitionKeyRangeCache = partitionKeyRangeCache;
        this.collectionLink = collectionLink;
        this.nextRetryPolicy = nextRetryPolicy;
        this.requestOptionProperties = requestOptionProperties;
        this.request = null;
    }

    @Override
    public Mono<ShouldRetryResult> shouldRetry(Exception exception) {
        CosmosException clientException = Utils.as(exception, CosmosException.class);
        if (clientException != null && Exceptions.isStatusCode(clientException, 410) && Exceptions.isSubStatusCode(clientException, 1002)) {
            if (this.retried) {
                return Mono.just((Object)ShouldRetryResult.error((Exception)((Object)clientException)));
            }
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(this.diagnosticsClientContext, OperationType.Read, ResourceType.DocumentCollection, this.collectionLink, null);
            if (this.requestOptionProperties != null) {
                request.properties = this.requestOptionProperties;
            }
            Mono<Utils.ValueHolder<DocumentCollection>> collectionObs = this.collectionCache.resolveCollectionAsync(BridgeInternal.getMetaDataDiagnosticContext(this.request.requestContext.cosmosDiagnostics), request);
            return collectionObs.flatMap(collectionValueHolder -> {
                Mono<Utils.ValueHolder<CollectionRoutingMap>> routingMapObs = this.partitionKeyRangeCache.tryLookupAsync(BridgeInternal.getMetaDataDiagnosticContext(this.request.requestContext.cosmosDiagnostics), ((DocumentCollection)collectionValueHolder.v).getResourceId(), null, request.properties);
                Mono refreshedRoutingMapObs = routingMapObs.flatMap(routingMapValueHolder -> {
                    if (routingMapValueHolder.v != null) {
                        return this.partitionKeyRangeCache.tryLookupAsync(null, ((DocumentCollection)collectionValueHolder.v).getResourceId(), (CollectionRoutingMap)routingMapValueHolder.v, request.properties);
                    }
                    return Mono.just(new Utils.ValueHolder<Object>(null));
                });
                return refreshedRoutingMapObs.flatMap(rm -> {
                    this.retried = true;
                    return Mono.just((Object)ShouldRetryResult.retryAfter(Duration.ZERO));
                });
            });
        }
        return this.nextRetryPolicy.shouldRetry(exception);
    }

    @Override
    public void onBeforeSendRequest(RxDocumentServiceRequest request) {
        this.request = request;
        this.nextRetryPolicy.onBeforeSendRequest(request);
    }

    @Override
    public RetryContext getRetryContext() {
        if (this.nextRetryPolicy != null) {
            return this.nextRetryPolicy.getRetryContext();
        }
        return null;
    }
}

