/*
 * Decompiled with CFR 0.152.
 */
package liquibase.snapshot;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import liquibase.CatalogAndSchema;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.SupportsMethodValidationLevelsEnum;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.LiquibaseTableNamesFactory;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.database.OfflineConnection;
import liquibase.database.core.MariaDBDatabase;
import liquibase.database.core.MockDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.diff.compare.DatabaseObjectComparatorFactory;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.ExecutorService;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.EmptyDatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.JdbcDatabaseSnapshot;
import liquibase.snapshot.SnapshotControl;
import liquibase.snapshot.SnapshotGenerator;
import liquibase.snapshot.SnapshotGeneratorComparator;
import liquibase.statement.core.RawParameterizedSqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import liquibase.util.LiquibaseUtil;

public class SnapshotGeneratorFactory {
    private static SnapshotGeneratorFactory instance;
    private final List<SnapshotGenerator> generators = new ArrayList<SnapshotGenerator>();
    protected static final String SUPPORTS_METHOD_REQUIRED_MESSAGE = "%s class does not properly implement the 'getPriority(Class<? extends DatabaseObject>, Database)' method and may incorrectly override other snapshot generators causing unexpected behavior. Please report this to the Liquibase developers or if you are developing this change please fix it ;)";

    protected SnapshotGeneratorFactory() {
        try {
            for (SnapshotGenerator generator : Scope.getCurrentScope().getServiceLocator().findInstances(SnapshotGenerator.class)) {
                this.verifyPriorityMethodImplementedCorrectly(generator);
                this.register(generator);
            }
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    private void verifyPriorityMethodImplementedCorrectly(SnapshotGenerator generator) {
        if (GlobalConfiguration.SUPPORTS_METHOD_VALIDATION_LEVEL.getCurrentValue().equals((Object)SupportsMethodValidationLevelsEnum.OFF)) {
            return;
        }
        try {
            int priority = generator.getPriority(null, new MockDatabase());
            if (priority != -1) {
                if (LiquibaseUtil.isDevVersion()) {
                    throw new UnexpectedLiquibaseException(String.format(SUPPORTS_METHOD_REQUIRED_MESSAGE, generator.getClass().getName()));
                }
                switch (GlobalConfiguration.SUPPORTS_METHOD_VALIDATION_LEVEL.getCurrentValue()) {
                    case WARN: {
                        Scope.getCurrentScope().getLog(this.getClass()).warning(String.format(SUPPORTS_METHOD_REQUIRED_MESSAGE, generator.getClass().getName()));
                        break;
                    }
                    case FAIL: {
                        throw new UnexpectedLiquibaseException(String.format(SUPPORTS_METHOD_REQUIRED_MESSAGE, generator.getClass().getName()));
                    }
                }
            }
        }
        catch (UnexpectedLiquibaseException ue) {
            throw ue;
        }
        catch (Exception e) {
            Scope.getCurrentScope().getLog(this.getClass()).fine("Failed to check validity of getPriority method in " + generator.getClass().getSimpleName() + " snapshot generator.", e);
        }
    }

    public static synchronized SnapshotGeneratorFactory getInstance() {
        if (instance == null) {
            instance = new SnapshotGeneratorFactory();
        }
        return instance;
    }

    public static synchronized void reset() {
        instance = new SnapshotGeneratorFactory();
    }

    public static synchronized void resetAll() {
        instance = null;
    }

    public void register(SnapshotGenerator generator) {
        this.generators.add(generator);
    }

    public void unregister(SnapshotGenerator generator) {
        this.generators.remove(generator);
    }

    public void unregister(Class generatorClass) {
        SnapshotGenerator toRemove = null;
        for (SnapshotGenerator existingGenerator : this.generators) {
            if (!existingGenerator.getClass().equals(generatorClass)) continue;
            toRemove = existingGenerator;
        }
        this.unregister(toRemove);
    }

    protected SortedSet<SnapshotGenerator> getGenerators(Class<? extends DatabaseObject> generatorClass, Database database) {
        TreeSet<SnapshotGenerator> validGenerators = new TreeSet<SnapshotGenerator>(new SnapshotGeneratorComparator(generatorClass, database));
        for (SnapshotGenerator generator : this.generators) {
            if (generator.getPriority(generatorClass, database) <= 0) continue;
            validGenerators.add(generator);
        }
        return validGenerators;
    }

    private Set<Class<? extends DatabaseObject>> initializeSnapshotTypes(DatabaseObject example, Database database) {
        HashSet<Class<? extends DatabaseObject>> types = new HashSet<Class<? extends DatabaseObject>>(this.getContainerTypes(example.getClass(), database));
        types.add(example.getClass());
        return types;
    }

    private boolean checkLiquibaseTablesExistence(DatabaseObject example, Database database, List<String> liquibaseTableNames) throws DatabaseException {
        if (example instanceof Table && liquibaseTableNames.contains(example.getName())) {
            try {
                if (database instanceof MariaDBDatabase) {
                    String sql = "select table_name from information_schema.TABLES where TABLE_SCHEMA = ? and TABLE_NAME = ?;";
                    List<Map<String, ?>> res = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", database).queryForList(new RawParameterizedSqlStatement(sql, database.getLiquibaseCatalogName(), example.getName()));
                    return !res.isEmpty();
                }
                Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", database).queryForInt(new RawParameterizedSqlStatement(String.format("SELECT COUNT(*) FROM %s", database.escapeObjectName(database.getLiquibaseCatalogName(), database.getLiquibaseSchemaName(), example.getName(), Table.class))));
                return true;
            }
            catch (DatabaseException e) {
                if (database instanceof PostgresDatabase) {
                    database.rollback();
                }
                return false;
            }
        }
        return false;
    }

    private boolean createAndCheckSnapshot(DatabaseObject example, Database database, SnapshotControl snapshotControl) throws DatabaseException, InvalidExampleException {
        if (this.createSnapshot(example, database, snapshotControl) != null) {
            return true;
        }
        CatalogAndSchema catalogAndSchema = example.getSchema() == null ? database.getDefaultSchema() : example.getSchema().toCatalogAndSchema();
        SnapshotControl replacedSnapshotControl = new SnapshotControl(database, false, example.getClass());
        replacedSnapshotControl.setWarnIfObjectNotFound(false);
        replacedSnapshotControl.setSearchNestedObjects(snapshotControl.shouldSearchNestedObjects());
        DatabaseSnapshot snapshot = this.createSnapshot(catalogAndSchema, database, replacedSnapshotControl);
        for (DatabaseObject obj : snapshot.get(example.getClass())) {
            if (!DatabaseObjectComparatorFactory.getInstance().isSameObject(example, obj, null, database)) continue;
            return true;
        }
        return false;
    }

    public boolean has(DatabaseObject example, Database database) throws DatabaseException, InvalidExampleException {
        return this.checkExistence(example, database, true);
    }

    public boolean hasIgnoreNested(DatabaseObject example, Database database) throws DatabaseException, InvalidExampleException {
        return this.checkExistence(example, database, false);
    }

    private boolean checkExistence(DatabaseObject example, Database database, boolean searchNestedObjects) throws DatabaseException, InvalidExampleException {
        Set<Class<? extends DatabaseObject>> types = this.initializeSnapshotTypes(example, database);
        LiquibaseTableNamesFactory liquibaseTableNamesFactory = Scope.getCurrentScope().getSingleton(LiquibaseTableNamesFactory.class);
        List<String> liquibaseTableNames = liquibaseTableNamesFactory.getLiquibaseTableNames(database);
        if (this.checkLiquibaseTablesExistence(example, database, liquibaseTableNames)) {
            return true;
        }
        SnapshotControl snapshotControl = new SnapshotControl(database, false, types.toArray(new Class[0]));
        snapshotControl.setWarnIfObjectNotFound(false);
        snapshotControl.setSearchNestedObjects(searchNestedObjects);
        return this.createAndCheckSnapshot(example, database, snapshotControl);
    }

    public DatabaseSnapshot createSnapshot(CatalogAndSchema example, Database database, SnapshotControl snapshotControl) throws DatabaseException, InvalidExampleException {
        return this.createSnapshot(new CatalogAndSchema[]{example}, database, snapshotControl);
    }

    public DatabaseSnapshot createSnapshot(CatalogAndSchema[] examples, Database database, SnapshotControl snapshotControl) throws DatabaseException, InvalidExampleException {
        if (database == null) {
            return null;
        }
        DatabaseObject[] schemas = new Schema[examples.length];
        for (int i = 0; i < schemas.length; ++i) {
            examples[i] = examples[i].customize(database);
            schemas[i] = new Schema(examples[i].getCatalogName(), examples[i].getSchemaName());
        }
        Scope.getCurrentScope().getLog(SnapshotGeneratorFactory.class).info("Creating snapshot");
        return this.createSnapshot(schemas, database, snapshotControl);
    }

    public DatabaseSnapshot createSnapshot(DatabaseObject[] examples, Database database, SnapshotControl snapshotControl) throws DatabaseException, InvalidExampleException {
        DatabaseConnection conn = database.getConnection();
        if (conn == null) {
            return new EmptyDatabaseSnapshot(database, snapshotControl);
        }
        if (conn instanceof OfflineConnection) {
            DatabaseSnapshot snapshot = ((OfflineConnection)conn).getSnapshot(examples);
            if (snapshot == null) {
                throw new DatabaseException("No snapshotFile parameter specified for offline database");
            }
            return snapshot;
        }
        return new JdbcDatabaseSnapshot(examples, database, snapshotControl);
    }

    public <T extends DatabaseObject> T createSnapshot(T example, Database database) throws DatabaseException, InvalidExampleException {
        return this.createSnapshot(example, database, new SnapshotControl(database));
    }

    public <T extends DatabaseObject> T createSnapshot(T example, Database database, SnapshotControl snapshotControl) throws DatabaseException, InvalidExampleException {
        DatabaseSnapshot snapshot = this.createSnapshot(new DatabaseObject[]{example}, database, snapshotControl);
        return snapshot.get(example);
    }

    public Table getDatabaseChangeLogTable(SnapshotControl snapshotControl, Database database) throws DatabaseException {
        ObjectQuotingStrategy currentStrategy = database.getObjectQuotingStrategy();
        database.setObjectQuotingStrategy(ObjectQuotingStrategy.LEGACY);
        try {
            Table liquibaseTable = (Table)new Table().setName(database.getDatabaseChangeLogTableName()).setSchema(new Schema(database.getLiquibaseCatalogName(), database.getLiquibaseSchemaName()));
            Table table = this.createSnapshot(liquibaseTable, database, snapshotControl);
            return table;
        }
        catch (InvalidExampleException e) {
            throw new UnexpectedLiquibaseException(e);
        }
        finally {
            database.setObjectQuotingStrategy(currentStrategy);
        }
    }

    public Table getDatabaseChangeLogLockTable(Database database) throws DatabaseException {
        ObjectQuotingStrategy currentStrategy = database.getObjectQuotingStrategy();
        database.setObjectQuotingStrategy(ObjectQuotingStrategy.LEGACY);
        try {
            Table example = (Table)new Table().setName(database.getDatabaseChangeLogLockTableName()).setSchema(new Schema(database.getLiquibaseCatalogName(), database.getLiquibaseSchemaName()));
            Table table = this.createSnapshot(example, database);
            return table;
        }
        catch (InvalidExampleException e) {
            throw new UnexpectedLiquibaseException(e);
        }
        finally {
            database.setObjectQuotingStrategy(currentStrategy);
        }
    }

    public boolean hasDatabaseChangeLogTable(Database database) throws DatabaseException {
        ObjectQuotingStrategy currentStrategy = database.getObjectQuotingStrategy();
        database.setObjectQuotingStrategy(ObjectQuotingStrategy.LEGACY);
        try {
            boolean bl = this.has(new Table().setName(database.getDatabaseChangeLogTableName()).setSchema(new Schema(database.getLiquibaseCatalogName(), database.getLiquibaseSchemaName())), database);
            return bl;
        }
        catch (InvalidExampleException e) {
            throw new UnexpectedLiquibaseException(e);
        }
        finally {
            database.setObjectQuotingStrategy(currentStrategy);
        }
    }

    public boolean hasDatabaseChangeLogLockTable(Database database) throws DatabaseException {
        ObjectQuotingStrategy currentStrategy = database.getObjectQuotingStrategy();
        database.setObjectQuotingStrategy(ObjectQuotingStrategy.LEGACY);
        try {
            boolean bl = this.has(new Table().setName(database.getDatabaseChangeLogLockTableName()).setSchema(new Schema(database.getLiquibaseCatalogName(), database.getLiquibaseSchemaName())), database);
            return bl;
        }
        catch (InvalidExampleException e) {
            throw new UnexpectedLiquibaseException(e);
        }
        finally {
            database.setObjectQuotingStrategy(currentStrategy);
        }
    }

    public Set<Class<? extends DatabaseObject>> getContainerTypes(Class<? extends DatabaseObject> type, Database database) {
        HashSet<Class<? extends DatabaseObject>> returnSet = new HashSet<Class<? extends DatabaseObject>>();
        this.getContainerTypes(type, database, returnSet);
        return returnSet;
    }

    private void getContainerTypes(Class<? extends DatabaseObject> type, Database database, Set<Class<? extends DatabaseObject>> returnSet) {
        SnapshotGenerator generator;
        Class<? extends DatabaseObject>[] addsTo;
        if (!returnSet.add(type)) {
            return;
        }
        SortedSet<SnapshotGenerator> generators = this.getGenerators(type, database);
        if (generators != null && !generators.isEmpty() && (addsTo = (generator = (SnapshotGenerator)generators.iterator().next()).addsTo()) != null) {
            for (Class<? extends DatabaseObject> newType : addsTo) {
                returnSet.add(newType);
                this.getContainerTypes(newType, database, returnSet);
            }
        }
    }
}

