/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.net.auth.aws;

import com.dbeaver.net.auth.aws.AWSAuthType;
import com.dbeaver.net.auth.aws.AuthModelAWSCredentials;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.access.DBAAuthCredentialsForm;
import org.jkiss.dbeaver.model.auth.AuthProperty;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.IPropertyValueValidator;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.regions.Region;

public class AuthModelAWSCredentialsForm
implements DBAAuthCredentialsForm {
    protected final List<AWSAuthType> applicableAuthTypes = new ArrayList<AWSAuthType>();
    @Nullable
    private final DBPDataSourceContainer container;
    @Nullable
    private final DBPConnectionConfiguration configuration;
    @NotNull
    private final AuthModelAWSCredentials credentials;
    private final boolean userNameVisible;
    private final boolean regionVisible;

    public AuthModelAWSCredentialsForm(@Nullable DBPDataSourceContainer container, @Nullable DBPConnectionConfiguration configuration, @NotNull AuthModelAWSCredentials credentials, boolean userNameVisible, boolean regionVisible) {
        this.container = container;
        this.configuration = configuration;
        this.credentials = credentials;
        this.userNameVisible = userNameVisible;
        this.regionVisible = regionVisible;
        this.applicableAuthTypes.add(AWSAuthType.KEY);
        this.applicableAuthTypes.add(AWSAuthType.DEFAULT);
        this.applicableAuthTypes.add(AWSAuthType.USER_PASSWORD);
        if (this.isMultiUserApplication()) {
            this.applicableAuthTypes.add(AWSAuthType.SESSION_CREDENTIALS);
        }
    }

    @Property(order=1, listProvider=AuthTypeListProvider.class, visibleIf=AwsAuthTypeFieldVisibleValidator.class, features={"large"})
    public String getAuthType() {
        if (this.configuration != null) {
            Map authProperties = this.configuration.getAuthProperties();
            if (CommonUtils.getBoolean((String)((String)authProperties.get("iam.use_default_aws")), (boolean)Boolean.FALSE)) {
                return AWSAuthType.DEFAULT.getTitle();
            }
            if (this.isMultiUserApplication() && CommonUtils.toBoolean(authProperties.get("iam.use_session_credentials"))) {
                return AWSAuthType.SESSION_CREDENTIALS.getTitle();
            }
            if (CommonUtils.getBoolean((String)CommonUtils.toString(authProperties.get("iam.use_password")))) {
                return AWSAuthType.USER_PASSWORD.getTitle();
            }
        }
        return AWSAuthType.KEY.getTitle();
    }

    @Property(order=2, nonSecuredProperty=true, required=true, visibleIf=AwsRegionFieldVisibleValidator.class, listProvider=AwsRegionValuesProvider.class)
    public String getRegion() {
        return this.credentials.getRegion();
    }

    @Property(order=3, hideExpr="object.authType != 'Access/secret keys'")
    @AuthProperty(authContextType="aws")
    public String getAwsAccessKey() {
        return this.credentials.getAwsAccessKey();
    }

    @Property(order=4, password=true, keyName="iam.aws_secret_key", hideExpr="object.authType != 'Access/secret keys'")
    @AuthProperty(authContextType="aws")
    public String getAwsSecretKey() {
        return this.credentials.getAwsSecretKey();
    }

    @Property(order=5, password=true, keyName="iam.aws_session_token", hideExpr="object.authType != 'Access/secret keys'")
    @AuthProperty(authContextType="aws")
    public String getAwsSessionToken() {
        return this.credentials.getAwsSessionToken();
    }

    @Property(order=3, visibleIf=AwsUserNameFieldVisibleValidator.class)
    public String getUserName() {
        return this.credentials.getUserName();
    }

    @Property(order=4, password=true, hideExpr="object.authType != 'User name/password'")
    public String getUserPassword() {
        return this.credentials.getUserPassword();
    }

    @Property(order=10, nonSecuredProperty=true)
    public String getAwsAssumeRoleName() {
        return this.credentials.getAwsAssumeRoleName();
    }

    @Property(order=11, nonSecuredProperty=true)
    public String getAwsHostName() {
        return this.credentials.getAwsServerEndpoint();
    }

    @Property(order=80, nonSecuredProperty=true, category="3rd party account")
    public boolean isCrossAccountAccess() {
        return this.credentials.isCrossAccountAccess();
    }

    @Property(order=81, nonSecuredProperty=true, category="3rd party account", hideExpr="object.crossAccountAccess != true")
    public String getAwsAssumeAccountId() {
        return this.credentials.getAwsAssumeAccountId();
    }

    @Property(order=82, nonSecuredProperty=true, category="3rd party account", hideExpr="object.crossAccountAccess != true")
    public String getAwsExternalId() {
        return this.credentials.getAwsExternalId();
    }

    @Property(order=90, nonSecuredProperty=true, category="Secret Manager")
    public boolean isUseSecretManager() {
        return CommonUtils.isNotEmpty((String)this.credentials.getSecretName());
    }

    @Property(order=91, nonSecuredProperty=true, category="Secret Manager", hideExpr="object.useSecretManager != true")
    public String getSecretName() {
        return this.credentials.getSecretName();
    }

    private boolean isMultiUserApplication() {
        return DBWorkbench.isDistributed() || DBWorkbench.getPlatform().getApplication().isMultiuser();
    }

    public static class AuthTypeListProvider
    implements IPropertyValueListProvider<AuthModelAWSCredentialsForm> {
        public boolean allowCustomValue() {
            return false;
        }

        @Nullable
        public Object[] getPossibleValues(AuthModelAWSCredentialsForm object) {
            return object.applicableAuthTypes.stream().map(AWSAuthType::getTitle).toArray();
        }
    }

    public static class AwsAuthTypeFieldVisibleValidator
    implements IPropertyValueValidator<AuthModelAWSCredentialsForm, Object> {
        public boolean isValidValue(@NotNull AuthModelAWSCredentialsForm object, @Nullable Object value) throws IllegalArgumentException {
            if (object.container == null) {
                return true;
            }
            return CommonUtils.equalObjects((Object)"local", (Object)object.container.getOrigin().getType());
        }
    }

    public static class AwsRegionFieldVisibleValidator
    implements IPropertyValueValidator<AuthModelAWSCredentialsForm, Object> {
        public boolean isValidValue(@NotNull AuthModelAWSCredentialsForm object, @Nullable Object value) throws IllegalArgumentException {
            return object.regionVisible;
        }
    }

    public static class AwsRegionValuesProvider
    implements IPropertyValueListProvider<AuthModelAWSCredentialsForm> {
        public boolean allowCustomValue() {
            return false;
        }

        @Nullable
        public Object[] getPossibleValues(AuthModelAWSCredentialsForm object) {
            return Region.regions().stream().filter(r -> !r.isGlobalRegion()).map(Region::id).sorted().toArray();
        }
    }

    public static class AwsUserNameFieldVisibleValidator
    implements IPropertyValueValidator<AuthModelAWSCredentialsForm, Object> {
        public boolean isValidValue(@NotNull AuthModelAWSCredentialsForm object, @Nullable Object value) throws IllegalArgumentException {
            return object.userNameVisible;
        }
    }
}

