/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util.timestamp;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.util.KsqlException;
import java.sql.Timestamp;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Locale;
import java.util.function.Function;
import org.apache.commons.lang3.ObjectUtils;

public class StringToTimestampParser {
    private static final Function<ZoneId, ZonedDateTime> DEFAULT_ZONED_DATE_TIME = zid -> ZonedDateTime.of(1970, 1, 1, 0, 0, 0, 0, zid);
    private static final long LEAP_DAY_OF_THE_YEAR = 366L;
    private final DateTimeFormatter formatter;

    public StringToTimestampParser(String pattern) {
        this.formatter = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern(pattern).toFormatter(Locale.ROOT);
    }

    public Timestamp parseToTimestamp(String text, ZoneId zoneId) {
        return Timestamp.from(this.parseZoned(text, zoneId).toInstant());
    }

    public long parse(String text) {
        return this.parse(text, ZoneId.systemDefault());
    }

    public long parse(String text, ZoneId zoneId) {
        return this.parseZoned(text, zoneId).toInstant().toEpochMilli();
    }

    @VisibleForTesting
    ZonedDateTime parseZoned(String text, ZoneId zoneId) {
        TemporalAccessor parsed = this.formatter.parse(text);
        ZoneId parsedZone = parsed.query(TemporalQueries.zone());
        ZonedDateTime resolved = DEFAULT_ZONED_DATE_TIME.apply((ZoneId)ObjectUtils.defaultIfNull((Object)parsedZone, (Object)zoneId));
        for (ChronoField override : ChronoField.values()) {
            if (!parsed.isSupported(override)) continue;
            if (!resolved.isSupported(override)) {
                throw new KsqlException("Unsupported temporal field in timestamp: " + text + " (" + override + ")");
            }
            long value = parsed.getLong(override);
            if (override == ChronoField.DAY_OF_YEAR && value == 366L) {
                if (!parsed.isSupported(ChronoField.YEAR)) {
                    throw new KsqlException("Leap day cannot be parsed without supplying the year field");
                }
                resolved = resolved.withYear(parsed.get(ChronoField.YEAR));
            }
            resolved = resolved.with(override, value);
        }
        return resolved;
    }
}

