/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.util.KsqlConfig;

public final class QueryApplicationId {
    public static String PERSISTENT_QUERY_INDICATOR = "query";

    private QueryApplicationId() {
    }

    public static String buildSharedRuntimeId(KsqlConfig config, boolean persistent, int sharedRuntimeIndex) {
        String queryAppId = QueryApplicationId.buildInternalTopicPrefix(config, persistent) + sharedRuntimeIndex;
        if (persistent) {
            return queryAppId;
        }
        return QueryApplicationId.addTimeSuffix(queryAppId);
    }

    public static String build(KsqlConfig config, boolean persistent, QueryId queryId) {
        String queryAppId = QueryApplicationId.buildInternalTopicPrefix(config, persistent) + queryId;
        if (persistent) {
            return queryAppId;
        }
        return QueryApplicationId.addTimeSuffix(queryAppId);
    }

    public static String buildInternalTopicPrefix(KsqlConfig config, boolean persistent) {
        String serviceId = config.getString("ksql.service.id");
        String configName = persistent ? "ksql.persistent.prefix" : "ksql.transient.prefix";
        String queryPrefix = config.getString(configName);
        return QueryApplicationId.buildInternalTopicPrefix(serviceId, queryPrefix);
    }

    public static String buildInternalTopicPrefix(String serviceId, String queryPrefix) {
        return "_confluent-ksql-" + serviceId + queryPrefix;
    }

    private static String addTimeSuffix(String original) {
        return String.format("%s_%d", original, System.currentTimeMillis());
    }
}

