/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.Immutable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.util.CompatibleElement;
import io.confluent.ksql.util.GrammaticalJoiner;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@Immutable
public class CompatibleSet<T extends CompatibleElement<T>> {
    protected final ImmutableSet<T> values;

    public CompatibleSet(Set<T> values) {
        CompatibleSet.validate(values);
        this.values = ImmutableSet.copyOf(values);
    }

    public boolean contains(T value) {
        return this.values.contains(value);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="values is ImmutableSet")
    public Set<T> all() {
        return this.values;
    }

    public Optional<T> findAny(Set<T> anyOf) {
        return anyOf.stream().filter(arg_0 -> this.values.contains(arg_0)).findAny();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompatibleSet that = (CompatibleSet)o;
        return Objects.equals(this.values, that.values);
    }

    public int hashCode() {
        return Objects.hash(this.values);
    }

    public String toString() {
        return this.values.toString();
    }

    private static <T extends CompatibleElement<T>> void validate(Set<T> values) {
        values.forEach(f -> {
            Sets.SetView incompatible = Sets.intersection(f.getIncompatibleWith(), (Set)values);
            if (!incompatible.isEmpty()) {
                throw new IllegalArgumentException("Can't set " + f + " with " + GrammaticalJoiner.or().join((Iterable<?>)incompatible));
            }
        });
    }
}

