/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.security.oauth;

import io.confluent.ksql.security.Credentials;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;

public class StaticTokenCredentials
implements Credentials {
    private String token;

    @Override
    public String getAuthHeader() {
        return "Bearer " + this.token;
    }

    @Override
    public void validateConfigs(Map<String, ?> configs) throws ConfigException {
        String token = (String)configs.get("bearer.auth.token");
        if (token == null || token.isEmpty()) {
            throw new ConfigException("Cannot configure StaticTokenCredentials without a proper token.");
        }
    }

    public void configure(Map<String, ?> configs) {
        this.validateConfigs(configs);
        this.token = (String)configs.get("bearer.auth.token");
    }
}

