/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.ksql;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.schema.ksql.SimpleColumn;
import io.confluent.ksql.serde.SerdeFeature;
import io.confluent.ksql.serde.SerdeFeatures;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

@Immutable
public final class PersistenceSchema {
    private final ImmutableList<SimpleColumn> columns;
    private final SerdeFeatures features;

    public static PersistenceSchema from(List<? extends SimpleColumn> columns, SerdeFeatures features) {
        return new PersistenceSchema(columns, features);
    }

    private PersistenceSchema(List<? extends SimpleColumn> columns, SerdeFeatures features) {
        this.features = Objects.requireNonNull(features, "features");
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns"));
        if ((features.enabled(SerdeFeature.WRAP_SINGLES) || features.enabled(SerdeFeature.UNWRAP_SINGLES)) && columns.size() != 1) {
            throw new IllegalArgumentException("Unwrapping only valid for single field");
        }
    }

    public SerdeFeatures features() {
        return this.features;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="columns is ImmutableList")
    public List<SimpleColumn> columns() {
        return this.columns;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersistenceSchema that = (PersistenceSchema)o;
        return Objects.equals(this.features, that.features) && Objects.equals(this.columns, that.columns);
    }

    public int hashCode() {
        return Objects.hash(this.features, this.columns);
    }

    public String toString() {
        return "Persistence{columns=" + this.columns + ", features=" + this.features + '}';
    }
}

