/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.parser.TokenLocation;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

@Immutable
public final class NodeLocation {
    private final TokenLocation start;
    private final Optional<TokenLocation> stop;

    public NodeLocation(TokenLocation start, TokenLocation stop) {
        this.start = start;
        this.stop = Optional.of(stop);
    }

    public NodeLocation(int startLine, int startCharPositionInLine) {
        this.start = TokenLocation.of(startLine, startCharPositionInLine);
        this.stop = Optional.empty();
    }

    public int getStartLineNumber() {
        return this.start.getLine();
    }

    public int getStartColumnNumber() {
        return this.start.getCharPositionInLine() + 1;
    }

    public OptionalInt getLength() {
        return this.stop.map(tokenLocation -> OptionalInt.of(tokenLocation.getStopIndex() - this.start.getStartIndex() + 1)).orElseGet(OptionalInt::empty);
    }

    public TokenLocation getStartTokenLocation() {
        return this.start;
    }

    public Optional<TokenLocation> getStopTokenLocation() {
        return this.stop;
    }

    public String asPrefix() {
        return this.toString() + ": ";
    }

    public static String asPrefix(Optional<NodeLocation> location) {
        return location.map(NodeLocation::asPrefix).orElse("");
    }

    public String toString() {
        return String.format("Line: %d, Col: %d", this.start.getLine(), this.start.getCharPositionInLine() + 1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeLocation that = (NodeLocation)o;
        return this.start.equals(that.start) && this.stop.equals(that.stop);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.stop);
    }
}

