/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.metrics;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;

public class MetricAppender
extends AppenderSkeleton {
    private static final String KSQL_LOGGING_JMX_PREFIX = "io.confluent.ksql.metrics.logging";
    private static final String KSQL_LOGGING_METRIC_GROUP = "ksql-logging";
    private final Metrics metrics = new Metrics(new MetricConfig().samples(100).timeWindow(1L, TimeUnit.SECONDS), (List)ImmutableList.of((Object)new JmxReporter()), Time.SYSTEM, (MetricsContext)new KafkaMetricsContext("io.confluent.ksql.metrics.logging"));
    private final Sensor errors = this.metrics.sensor("ksql-logging-error-rate");
    private final Sensor warns;
    private final Sensor infos;

    public MetricAppender() {
        this.errors.add(this.metrics.metricName("errors", KSQL_LOGGING_METRIC_GROUP, "number of error logs per second"), (MeasurableStat)new Rate());
        this.warns = this.metrics.sensor("ksql-logging-warn-rate");
        this.warns.add(this.metrics.metricName("warns", KSQL_LOGGING_METRIC_GROUP, "number of warn logs per second"), (MeasurableStat)new Rate());
        this.infos = this.metrics.sensor("ksql-logging-info-rate");
        this.infos.add(this.metrics.metricName("infos", KSQL_LOGGING_METRIC_GROUP, "number of info logs per second"), (MeasurableStat)new Rate());
    }

    protected void append(LoggingEvent event) {
        if (event.getLevel() == Level.INFO) {
            this.infos.record();
        } else if (event.getLevel() == Level.WARN) {
            this.warns.record();
        } else if (event.getLevel() == Level.ERROR) {
            this.errors.record();
        }
    }

    public void close() {
        this.metrics.close();
    }

    public boolean requiresLayout() {
        return false;
    }
}

