/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.team.workspace.tasks;

import com.dbeaver.remote.client.tm.model.TMTaskRun;
import com.dbeaver.team.workspace.tasks.TeamTaskManagerImpl;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.task.DBTTaskFolder;
import org.jkiss.dbeaver.model.task.DBTTaskRun;
import org.jkiss.dbeaver.model.task.DBTTaskType;
import org.jkiss.dbeaver.registry.task.TaskImpl;

public class TeamTaskImpl
extends TaskImpl {
    private static final Log log = Log.getLog(TeamTaskImpl.class);
    private final TeamTaskManagerImpl taskManager;

    public TeamTaskImpl(@NotNull DBPProject project, @NotNull DBTTaskType type, @NotNull String id, @NotNull String label, @Nullable String description, @NotNull Date createTime, @Nullable Date updateTime, @Nullable DBTTaskFolder folder, @NotNull TeamTaskManagerImpl taskManager) {
        super(project, type, id, label, description, createTime, updateTime, folder);
        this.taskManager = taskManager;
    }

    @Nullable
    public Path getRunLog(@NotNull DBTTaskRun run) {
        if (run instanceof TMTaskRun) {
            return null;
        }
        return super.getRunLog(run);
    }

    @NotNull
    public InputStream getRunLogInputStream(@NotNull DBTTaskRun run) throws DBException, IOException {
        if (run instanceof TMTaskRun) {
            return this.taskManager.getClient().readTaskRunLogs(this.getProject().getId(), this.getId(), run.getId());
        }
        return super.getRunLogInputStream(run);
    }

    public void refreshRunStatistics() {
        this.taskManager.invalidateTaskRuns(this.getId());
        super.refreshRunStatistics();
    }

    @NotNull
    protected List<? extends DBTTaskRun> loadRunStatistics() {
        ArrayList<DBTTaskRun> runs = new ArrayList<DBTTaskRun>(super.loadRunStatistics());
        runs.addAll(Arrays.asList(this.taskManager.getTaskRuns(this)));
        runs.sort(Comparator.comparing(DBTTaskRun::getStartTime));
        return runs;
    }

    protected void flushRunStatistics(@NotNull List<? extends DBTTaskRun> runs) {
        runs = new ArrayList<DBTTaskRun>(runs);
        runs.removeIf(run -> run instanceof TMTaskRun);
        super.flushRunStatistics(runs);
    }
}

