/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.team.workspace.events;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.websocket.WSEventHandler;
import org.jkiss.dbeaver.model.websocket.event.WSTaskFinishedEvent;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;

public class EventHandlerTask
implements WSEventHandler<WSTaskFinishedEvent> {
    private static final Log log = Log.getLog(EventHandlerTask.class);

    public void handleEvent(@NotNull WSTaskFinishedEvent event) {
        log.debug((Object)("Task executed: " + event.getTopicId() + " event handled"));
        DBPProject project = DBWorkbench.getPlatform().getWorkspace().getProjectById(event.getProjectId());
        if (project != null) {
            DBTTask task = project.getTaskManager().getTaskById(event.getTaskId());
            UIUtils.asyncExec(() -> {
                try {
                    if (task != null) {
                        project.getTaskManager().updateTaskConfiguration(task);
                    }
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError("Task update error", "Error handling task execution event", (Throwable)e);
                }
            });
        }
    }
}

