/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.team.workspace.events;

import com.dbeaver.team.workspace.TeamWorkspaceImpl;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.websocket.WSEventHandler;
import org.jkiss.dbeaver.model.websocket.event.WSProjectUpdateEvent;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.DBeaverNotifications;
import org.jkiss.dbeaver.ui.UIExecutionQueue;

public class EventHandlerProjectUpdate
implements WSEventHandler<WSProjectUpdateEvent> {
    private static final Log log = Log.getLog(EventHandlerProjectUpdate.class);

    public void handleEvent(@NotNull WSProjectUpdateEvent event) {
        log.debug((Object)(event.getTopicId() + " event handled"));
        DBPWorkspace workspace = DBWorkbench.getPlatform().getWorkspace();
        if (workspace instanceof TeamWorkspaceImpl) {
            TeamWorkspaceImpl teamWorkspace = (TeamWorkspaceImpl)workspace;
            UIExecutionQueue.queueExec(() -> {
                try {
                    switch (event.getId()) {
                        case "cb_rm_project_added": {
                            teamWorkspace.addProjectToCache(event.getProjectId());
                            break;
                        }
                        case "cb_rm_project_updated": {
                            teamWorkspace.updateProjectInCache(event.getProjectId(), event.getProjectInfo());
                            break;
                        }
                        case "cb_rm_project_removed": {
                            teamWorkspace.removeProjectFromCache(event.getProjectId());
                            break;
                        }
                    }
                }
                catch (DBException e) {
                    log.error((Object)"Error refreshing workspace projects", (Throwable)e);
                }
            });
        }
        DBPProject project = DBWorkbench.getPlatform().getWorkspace().getProjectById(event.getProjectId());
        switch (event.getId()) {
            case "cb_rm_project_added": {
                DBeaverNotifications.showNotification((String)"te.refresh.project.added", (String)"Access to project added", (String)("Access to the project '" + (project != null ? project.getName() : event.getProjectId()) + "' added remotely"), (DBPMessageType)DBPMessageType.INFORMATION, null);
                break;
            }
            case "cb_rm_project_removed": {
                DBeaverNotifications.showNotification((String)"te.refresh.project.removed", (String)"Access to project removed", (String)("Access to the project '" + (project != null ? project.getName() : event.getProjectId()) + "' removed remotely"), (DBPMessageType)DBPMessageType.INFORMATION, null);
                break;
            }
            case "cb_rm_project_updated": {
                DBeaverNotifications.showNotification((String)"te.refresh.project.updated", (String)"Project updated", (String)"Project '%s' updated remotely\n(new name: '%s')\n".formatted(event.getProjectId(), event.getProjectInfo() != null ? event.getProjectInfo().getName() : ""), (DBPMessageType)DBPMessageType.INFORMATION, null);
                break;
            }
        }
    }
}

