/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.team.workspace;

import com.dbeaver.ee.runtime.auth.IdentityProviderRegistry;
import com.dbeaver.model.auth.SMApplicationIdentityProvider;
import com.dbeaver.model.auth.SMSessionRemote;
import com.dbeaver.model.security.SMControllerProvider;
import com.dbeaver.remote.client.MSServiceType;
import com.dbeaver.remote.event.client.WSClient;
import com.dbeaver.remote.workspace.DesktopWorkspaceRemote;
import com.dbeaver.remote.workspace.RemoteProjectImpl;
import com.dbeaver.team.workspace.TeamProjectImpl;
import java.net.URI;
import javax.security.auth.callback.CallbackHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.auth.SMAuthInfo;
import org.jkiss.dbeaver.model.auth.SMCredentialsProvider;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.security.SMController;
import org.jkiss.dbeaver.model.security.user.SMAuthPermissions;
import org.jkiss.dbeaver.model.websocket.event.WSEventController;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class TeamWorkspaceImpl
extends DesktopWorkspaceRemote
implements SMControllerProvider {
    private static final Log log = Log.getLog(TeamWorkspaceImpl.class);
    private WSClient eventClient;
    private CallbackHandler callbackHandler;

    public TeamWorkspaceImpl(@NotNull DBPPlatform platform, @NotNull IWorkspace eclipseWorkspace, CallbackHandler callbackHandler) {
        super(platform, eclipseWorkspace);
        this.callbackHandler = callbackHandler;
    }

    @NotNull
    protected RemoteProjectImpl createRemoteProject(IProject project) {
        return new TeamProjectImpl(this, project, this.getAuthContext());
    }

    @NotNull
    protected SMSession acquireWorkspaceSession(@NotNull DBRProgressMonitor monitor) throws DBException {
        SMApplicationIdentityProvider identityProvider = IdentityProviderRegistry.getInstance().getGlobalIdentityProvider();
        return this.acquireSession(monitor, (DBPWorkspace)this, identityProvider);
    }

    @NotNull
    protected SMSession acquireSession(@NotNull DBRProgressMonitor monitor, @NotNull DBPWorkspace workspace, @NotNull SMApplicationIdentityProvider provider) throws DBException {
        SMSession workspaceSession = provider.acquireApplicationSession(monitor, "User authentication", null, workspace, this.callbackHandler);
        try {
            this.initializeRemoteWorkspace(monitor, workspaceSession);
        }
        catch (DBException e) {
            workspaceSession.close();
            throw e;
        }
        return workspaceSession;
    }

    public boolean hasRealmPermission(@NotNull String permission) {
        SMAuthInfo authInfo = this.getWorkspaceAuthInfo();
        if (authInfo == null) {
            return false;
        }
        SMAuthPermissions authPermissions = authInfo.getAuthPermissions();
        if (authPermissions == null) {
            return false;
        }
        return authPermissions.getPermissions().contains(permission) || authPermissions.getPermissions().contains("admin");
    }

    public boolean supportsRealmFeature(@NotNull String feature) {
        return super.supportsRealmFeature(feature);
    }

    protected void initializeRemoteWorkspace(@NotNull DBRProgressMonitor monitor, @NotNull SMSession workspaceSession) throws DBException {
        super.initializeRemoteWorkspace(monitor, workspaceSession);
        SMSessionRemote sessionRemote = (SMSessionRemote)DBUtils.getAdapter(SMSessionRemote.class, (Object)workspaceSession);
        if (sessionRemote != null) {
            SMCredentialsProvider smCredentialsProvider = sessionRemote.getRemoteCredentialsProvider();
            if (smCredentialsProvider != null) {
                String emEndpoint = this.getUserConfiguration().getServiceEndpoint(MSServiceType.EVENT_MANAGER);
                if (emEndpoint == null) {
                    log.error((Object)"Cannot determine event manager server endpoint");
                } else {
                    this.createEventClient(smCredentialsProvider, emEndpoint);
                }
            } else {
                log.warn((Object)"Remote credentials provider not found");
            }
        } else {
            log.warn((Object)"Remote session not found");
        }
    }

    private void createEventClient(SMCredentialsProvider smCredentialsProvider, String emEndpoint) throws DBException {
        log.debug((Object)("Connect to event manager at '" + emEndpoint + "'"));
        WSEventController clientEventController = new WSEventController();
        this.eventClient = new WSClient(URI.create(emEndpoint), smCredentialsProvider, clientEventController);
        Thread connectionThread = new Thread(() -> {
            try {
                this.eventClient.connect();
            }
            catch (DBException e) {
                log.error((Object)"Error connecting event client", (Throwable)e);
                throw new RuntimeException(e);
            }
        }, "TE Desktop WebSocket Thread");
        connectionThread.start();
        int maxCount = 100;
        int i = 0;
        while (!this.eventClient.isConnected() && i < maxCount) {
            RuntimeUtils.pause((int)100);
            ++i;
        }
        if (!this.eventClient.isConnected()) {
            log.error((Object)"Event manager client is not connected");
        } else {
            log.debug((Object)"Event manager has been instantiated");
            clientEventController.scheduleCheckJob();
        }
    }

    public void loadWorkspaceProjects() throws DBException {
        super.loadWorkspaceProjects();
    }

    public WSClient getEventClient() {
        return this.eventClient;
    }

    public SMController getSecurityController() {
        return (SMController)DBUtils.getAdapter(SMController.class, (Object)this.getWorkspaceSession());
    }

    public void dispose() {
        if (this.eventClient != null && this.eventClient.isConnected()) {
            try {
                this.eventClient.closeConnection();
            }
            catch (DBException e) {
                log.error((Object)"Error closing websocket client", (Throwable)e);
            }
        }
        super.dispose();
    }
}

