/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.team.workspace;

import com.dbeaver.remote.workspace.DesktopWorkspaceRemote;
import com.dbeaver.remote.workspace.RemoteProjectImpl;
import com.dbeaver.team.workspace.TeamWorkspaceImpl;
import com.dbeaver.team.workspace.tasks.TeamTaskManagerImpl;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.auth.SMAuthInfo;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.auth.SMSessionContext;
import org.jkiss.dbeaver.model.impl.app.BaseProjectImpl;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.security.SMController;
import org.jkiss.dbeaver.model.security.SMObjectType;
import org.jkiss.dbeaver.model.security.user.SMObjectPermissions;
import org.jkiss.dbeaver.model.task.DBTTaskManager;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;

public class TeamProjectImpl
extends RemoteProjectImpl {
    private static final Log log = Log.getLog(TeamProjectImpl.class);
    private transient SMObjectPermissions projectPermissions;

    public TeamProjectImpl(@NotNull TeamWorkspaceImpl workspace, @NotNull IProject eclipseProject, @Nullable SMSessionContext sessionContext) {
        super((DesktopWorkspaceRemote)workspace, eclipseProject, sessionContext);
        this.rmProject = workspace.getRmProject(this.getId());
        if (this.rmProject != null) {
            this.projectPermissions = new SMObjectPermissions(this.getId(), this.rmProject.getProjectPermissions());
        }
    }

    public void refreshProject(DBRProgressMonitor monitor) {
        this.projectPermissions = null;
        super.refreshProject(monitor);
    }

    public boolean hasRealmPermission(@NotNull String permission) {
        if (this.getWorkspace().isAdmin() || this.isPrivateProject()) {
            return true;
        }
        if (this.isGlobalProject() && (permission.equals("project-datasource-view") || permission.equals("project-resource-view"))) {
            return true;
        }
        if (this.projectPermissions == null) {
            SMSession spaceSession = this.getWorkspace().getWorkspaceSession();
            SMController smController = (SMController)DBUtils.getAdapter(SMController.class, (Object)spaceSession);
            SMAuthInfo authInfo = (SMAuthInfo)GeneralUtils.adapt((Object)spaceSession, SMAuthInfo.class);
            if (smController != null && authInfo != null && authInfo.getAuthPermissions() != null) {
                try {
                    String userId = authInfo.getAuthPermissions().getUserId();
                    if (userId != null) {
                        this.projectPermissions = smController.getObjectPermissions(userId, this.getId(), SMObjectType.project);
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Error reading project permissions", (Throwable)e);
                }
            } else {
                log.error((Object)"Cannot determine active remote session credentials");
            }
        }
        if (this.projectPermissions == null) {
            this.projectPermissions = new SMObjectPermissions(this.getId(), Set.of());
        }
        return ArrayUtils.contains((Object[])this.projectPermissions.getPermissions(), (Object)permission);
    }

    public boolean supportsRealmFeature(@NotNull String feature) {
        return super.supportsRealmFeature(feature);
    }

    public boolean isUseSecretStorage() {
        return true;
    }

    @NotNull
    protected DBTTaskManager createTaskManager() {
        return new TeamTaskManagerImpl((BaseProjectImpl)this, this.getWorkspace().getMetadataFolder().resolve("task-stats"));
    }
}

