/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.team.ui;

import com.dbeaver.model.auth.SMSessionRemote;
import com.dbeaver.remote.client.dc.DCClientConfiguration;
import com.dbeaver.remote.client.dc.DCRemoteSecurityController;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ModelPreferences;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.access.DBAAuthModel;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.dbeaver.model.secret.DBSSecretObject;
import org.jkiss.dbeaver.model.secret.DBSSecretValue;
import org.jkiss.dbeaver.model.security.SMAdminController;
import org.jkiss.dbeaver.model.security.user.SMTeam;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourceUtils;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorDescriptor;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.jobs.ConnectionTestJob;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionTestDialog;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class SharedCredentialsManageDialog
extends BaseDialog {
    private static final Log log = Log.getLog(SharedCredentialsManageDialog.class);
    private final DataSourceDescriptor dataSource;
    private Table teamTable;
    private IObjectPropertyConfigurator<Object, DBPDataSourceContainer> authModelConfigurator;
    private ControlEnableState credEnableState;
    private Group credGroup;
    private DCRemoteSecurityController smController;
    private final Map<String, DBSSecretValue> teamSecrets = new LinkedHashMap<String, DBSSecretValue>();
    private boolean credsChanged = false;

    public SharedCredentialsManageDialog(Shell parentShell, DBPDataSourceContainer dataSource) {
        super(parentShell, "Manage credentials (" + dataSource.getName() + ")", null);
        this.dataSource = (DataSourceDescriptor)dataSource.getRegistry().createDataSource(dataSource);
        this.dataSource.setId(dataSource.getId());
        this.dataSource.setTemporary(true);
    }

    @NotNull
    protected Composite createDialogArea(@NotNull Composite parent) {
        Composite dialogArea = super.createDialogArea(parent);
        Group teamsGroup = UIUtils.createControlGroup((Composite)dialogArea, (String)"Teams", (int)2, (int)1808, (int)-1);
        teamsGroup.setLayoutData((Object)new GridData(1808));
        this.teamTable = new Table((Composite)teamsGroup, 67588);
        GridData gd = new GridData(1808);
        gd.widthHint = 60 * UIUtils.getFontHeight((Control)this.teamTable);
        gd.heightHint = 20 * UIUtils.getFontHeight((Control)this.teamTable);
        this.teamTable.setLayoutData((Object)gd);
        UIUtils.createTableColumn((Table)this.teamTable, (int)16384, (String)"Team");
        UIUtils.createTableColumn((Table)this.teamTable, (int)16384, (String)"User");
        this.teamTable.setHeaderVisible(true);
        ToolBar toolbar = new ToolBar((Composite)teamsGroup, 512);
        toolbar.setLayoutData((Object)new GridData(2));
        UIUtils.createToolItem((ToolBar)toolbar, (String)UIConnectionMessages.pref_page_drivers_button_add, (DBPImage)UIIcon.ADD, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TeamSelectorDialog dialog = new TeamSelectorDialog();
                if (dialog.open() == 0) {
                    DBSSecretValue newSecret = new DBSSecretValue(dialog.selectedTeam, "", "", "");
                    SharedCredentialsManageDialog.this.createTeamSecret(newSecret);
                    SharedCredentialsManageDialog.this.credsChanged = true;
                }
            }
        });
        ToolItem removeButton = UIUtils.createToolItem((ToolBar)toolbar, (String)UIConnectionMessages.pref_page_drivers_button_remove, (DBPImage)UIIcon.DELETE, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBSSecretValue teamSecret = SharedCredentialsManageDialog.this.getSelectedTeamSecret();
                if (teamSecret != null && UIUtils.confirmAction((Shell)SharedCredentialsManageDialog.this.getShell(), (String)"Delete team credentials", (String)("Are you sure your want to delete credentials for team '" + DataSourceUtils.getSubjectFromSecret((DBSSecretValue)teamSecret) + "'?"))) {
                    SharedCredentialsManageDialog.this.deleteTeamSecret(teamSecret);
                    SharedCredentialsManageDialog.this.credsChanged = true;
                }
            }
        });
        removeButton.setEnabled(false);
        this.teamTable.addSelectionListener(SelectionListener.widgetSelectedAdapter(selectionEvent -> {
            boolean hasSelection = this.teamTable.getSelectionIndex() != -1;
            removeButton.setEnabled(hasSelection);
            DBSSecretValue curSecret = this.getSelectedTeamSecret();
            this.loadTeamCredentials(curSecret);
        }));
        this.credGroup = UIUtils.createControlGroup((Composite)dialogArea, (String)"Credentials", (int)2, (int)1808, (int)-1);
        DBAAuthModel authModel = this.dataSource.getConnectionConfiguration().getAuthModel();
        UIPropertyConfiguratorDescriptor uiConfiguratorDescriptor = UIPropertyConfiguratorRegistry.getInstance().getDescriptor((Object)authModel);
        if (uiConfiguratorDescriptor != null) {
            try {
                this.authModelConfigurator = uiConfiguratorDescriptor.createConfigurator();
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        } else {
            log.debug((Object)("No UI configurator for auth model " + String.valueOf(authModel)));
        }
        if (this.authModelConfigurator != null) {
            this.authModelConfigurator.createControl((Composite)this.credGroup, (Object)authModel, () -> {});
            Composite buttonsPanel = UIUtils.createComposite((Composite)this.credGroup, (int)2);
            GridData gd2 = new GridData(768);
            gd2.horizontalSpan = 2;
            buttonsPanel.setLayoutData((Object)gd2);
            UIUtils.createDialogButton((Composite)buttonsPanel, (String)"Save", (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        SharedCredentialsManageDialog.this.saveTeamCredentials(SharedCredentialsManageDialog.this.getSelectedTeamSecret());
                        SharedCredentialsManageDialog.this.credsChanged = true;
                    }
                    catch (DBException ex) {
                        DBWorkbench.getPlatformUI().showError("Credentials save", "Error saving team credentials", (Throwable)ex);
                    }
                }
            });
            UIUtils.createDialogButton((Composite)buttonsPanel, (String)CoreMessages.dialog_connection_wizard_final_button_test, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SharedCredentialsManageDialog.this.testConnection(SharedCredentialsManageDialog.this.getSelectedTeamSecret());
                }
            });
        }
        this.loadTeams();
        this.loadTeamCredentials(null);
        UIUtils.asyncExec(() -> UIUtils.packColumns((Table)this.teamTable, (boolean)true));
        return dialogArea;
    }

    private void testConnection(DBSSecretValue secret) {
        this.authModelConfigurator.saveSettings((Object)this.dataSource);
        String newSecret = this.dataSource.saveToSecret();
        if (newSecret != null) {
            secret.setValue(newSecret);
        }
        DataSourceDescriptor testDataSource = (DataSourceDescriptor)this.dataSource.getRegistry().createDataSource((DBPDataSourceContainer)this.dataSource);
        testDataSource.setTemporary(true);
        testDataSource.setSelectedSharedCredentials(secret);
        testDataSource.setId(DataSourceDescriptor.generateNewId((DBPDriver)this.dataSource.getDriver()));
        testDataSource.getPreferenceStore().setValue("database.meta.separate.connection", ModelPreferences.SeparateConnectionBehavior.NEVER.name());
        try {
            ConnectionTestJob op = new ConnectionTestJob((DBPDataSourceContainer)testDataSource, session -> {});
            try {
                UIUtils.runInProgressDialog(monitor -> {
                    op.run(monitor);
                    if (op.getConnectError() != null) {
                        throw new InvocationTargetException(op.getConnectError());
                    }
                    if (op.getConnectStatus() == Status.CANCEL_STATUS) {
                        throw new InterruptedException("cancel");
                    }
                });
                new ConnectionTestDialog(this.getShell(), this.dataSource, op.getServerVersion(), op.getClientVersion(), op.getConnectTime()).open();
            }
            catch (InvocationTargetException ex) {
                String msg = GeneralUtils.getExceptionMessage((Throwable)ex);
                DBWorkbench.getPlatformUI().showError(CoreMessages.dialog_connection_wizard_start_dialog_error_title, msg, GeneralUtils.makeExceptionStatus((Throwable)ex.getTargetException()));
            }
        }
        finally {
            testDataSource.dispose();
        }
    }

    @Nullable
    private DBSSecretValue getSelectedTeamSecret() {
        int selectionIndex = this.teamTable.getSelectionIndex();
        return selectionIndex >= 0 ? (DBSSecretValue)this.teamTable.getItem(selectionIndex).getData() : null;
    }

    private void loadTeams() {
        try {
            this.dataSource.resetAllSecrets();
            for (DBSSecretValue secret : this.listAllSharedCredentials(this.dataSource)) {
                this.createTeamSecret(secret);
            }
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Load team credentials", null, (Throwable)e);
        }
    }

    @NotNull
    public synchronized List<DBSSecretValue> listAllSharedCredentials(@NotNull DataSourceDescriptor dataSource) throws DBException {
        DBSSecretController secretController = DBSSecretController.getProjectSecretController((DBPProject)dataSource.getProject());
        return secretController.listAllSharedSecrets((DBSSecretObject)dataSource);
    }

    private void createTeamSecret(DBSSecretValue secret) {
        String subjectId = DataSourceUtils.getSubjectFromSecret((DBSSecretValue)secret);
        this.teamSecrets.put(subjectId, secret);
        TableItem item = new TableItem(this.teamTable, 0);
        item.setText(0, subjectId);
        item.setText(1, DataSourceUtils.getUserNameFromSecret((DBSSecretValue)secret));
        item.setData((Object)secret);
    }

    private void deleteTeamSecret(DBSSecretValue teamSecret) {
        String subjectId = DataSourceUtils.getSubjectFromSecret((DBSSecretValue)teamSecret);
        try {
            DBSSecretController secretController = DBSSecretController.getProjectSecretController((DBPProject)this.dataSource.getProject());
            secretController.setSubjectSecretValue(subjectId, (DBSSecretObject)this.dataSource, new DBSSecretValue(subjectId, teamSecret.getId(), "", null));
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Delete credentials", "Error deleting team credentials", (Throwable)e);
            return;
        }
        TableItem[] tableItemArray = this.teamTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            DBSSecretValue secret = (DBSSecretValue)item.getData();
            if (CommonUtils.equalObjects((Object)secret.getId(), (Object)teamSecret.getId()) && CommonUtils.equalObjects((Object)secret.getSubjectId(), (Object)teamSecret.getSubjectId())) {
                item.dispose();
            }
            ++n2;
        }
        this.teamSecrets.remove(subjectId);
    }

    private void loadTeamCredentials(DBSSecretValue secret) {
        if (this.authModelConfigurator == null || secret == null) {
            if (this.credEnableState == null) {
                this.credEnableState = ControlEnableState.disable((Control)this.credGroup);
            }
            return;
        }
        if (this.credEnableState != null) {
            this.credEnableState.restore();
            this.credEnableState = null;
        }
        this.dataSource.setSelectedSharedCredentials(secret);
        this.authModelConfigurator.loadSettings((Object)this.dataSource);
    }

    private void saveTeamCredentials(DBSSecretValue teamSecret) throws DBException {
        this.authModelConfigurator.saveSettings((Object)this.dataSource);
        DBSSecretController secretController = DBSSecretController.getProjectSecretController((DBPProject)this.dataSource.getProject());
        this.dataSource.persistSecrets(secretController);
        String newSecret = this.dataSource.saveToSecret();
        if (newSecret != null) {
            teamSecret.setValue(newSecret);
            TableItem item = this.teamTable.getItem(this.teamTable.getSelectionIndex());
            item.setText(1, DataSourceUtils.getUserNameFromSecret((DBSSecretValue)teamSecret));
        }
    }

    public SMAdminController getAdminController() throws DBException {
        if (this.smController == null) {
            SMSession spaceSession = DBWorkbench.getPlatform().getWorkspace().getWorkspaceSession();
            SMSessionRemote sessionRemote = (SMSessionRemote)DBUtils.getAdapter(SMSessionRemote.class, (Object)spaceSession);
            if (sessionRemote == null) {
                throw new DBException("No remote session found");
            }
            DCClientConfiguration clientConfig = DCClientConfiguration.builder((SMSessionRemote)sessionRemote).build();
            this.smController = new DCRemoteSecurityController(clientConfig);
        }
        return this.smController;
    }

    private boolean hasTeamCredentials(String teamId) {
        return this.teamSecrets.containsKey(teamId);
    }

    protected void createButtonsForButtonBar(@NotNull Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1 && this.credsChanged) {
            buttonId = 0;
        }
        super.buttonPressed(buttonId);
    }

    public class TeamSelectorDialog
    extends BaseDialog {
        private String selectedTeam;

        public TeamSelectorDialog() {
            super(SharedCredentialsManageDialog.this.getShell(), "Select team", null);
        }

        @NotNull
        protected Composite createDialogArea(@NotNull Composite parent) {
            Composite dialogArea = super.createDialogArea(parent);
            Group teamListGroup = UIUtils.createControlGroup((Composite)dialogArea, (String)"Teams", (int)2, (int)1808, (int)-1);
            teamListGroup.setLayoutData((Object)new GridData(1808));
            final org.eclipse.swt.widgets.List teamListTable = new org.eclipse.swt.widgets.List((Composite)teamListGroup, 68100);
            GridData gd = new GridData(1808);
            gd.widthHint = 40 * UIUtils.getFontHeight((Control)teamListTable);
            gd.heightHint = 10 * UIUtils.getFontHeight((Control)teamListTable);
            teamListTable.setLayoutData((Object)gd);
            try {
                SMTeam[] sMTeamArray = SharedCredentialsManageDialog.this.getAdminController().readAllTeams();
                int n = sMTeamArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SMTeam team = sMTeamArray[n2];
                    if (!SharedCredentialsManageDialog.this.hasTeamCredentials(team.getTeamId())) {
                        teamListTable.add(team.getTeamId());
                    }
                    ++n2;
                }
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError("Read teams", "Teams read failed", (Throwable)e);
            }
            teamListTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int selectionIndex = teamListTable.getSelectionIndex();
                    TeamSelectorDialog.this.selectedTeam = selectionIndex < 0 ? null : teamListTable.getItem(selectionIndex);
                    TeamSelectorDialog.this.enableButton(0, TeamSelectorDialog.this.selectedTeam != null);
                }
            });
            return dialogArea;
        }

        protected Control createContents(@NotNull Composite parent) {
            Control contents = super.createContents(parent);
            this.enableButton(0, false);
            return contents;
        }
    }
}

