/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.team.ui;

import com.dbeaver.team.ui.internal.TeamMessages;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.Section;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerDescriptor;
import org.jkiss.dbeaver.model.net.DBWNetworkProfile;
import org.jkiss.dbeaver.model.net.DBWUtils;
import org.jkiss.dbeaver.model.rcp.RCPProject;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.dbeaver.registry.configurator.DBPConnectionEditIntention;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorDescriptor;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.AbstractObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.IDataSourceConnectionEditorSite;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageWithAuth;
import org.jkiss.utils.Pair;

public class EditConnectionCredentialsDialog
extends BaseDialog
implements IDataSourceConnectionEditorSite {
    private static final Log log = Log.getLog(EditConnectionCredentialsDialog.class);
    @NotNull
    private final ConnectionPageWithAuth connectionPage;
    @NotNull
    private final DBPDataSourceContainer dataSourceContainer;
    @NotNull
    private final List<Pair<DBWHandlerConfiguration, IObjectPropertyConfigurator<Object, DBWHandlerConfiguration>>> handlerConfigurators;
    @NotNull
    private final Runnable handlerChangedListener = () -> {};

    public EditConnectionCredentialsDialog(@NotNull Shell parent, @NotNull DBPDataSourceContainer dataSourceContainer) throws DBException {
        super(parent, "Edit connection credentials of the " + dataSourceContainer.getName(), (DBPImage)UIIcon.EDIT);
        this.dataSourceContainer = dataSourceContainer;
        this.dataSourceContainer.resolveSecrets(DBSSecretController.getProjectSecretController((DBPProject)dataSourceContainer.getProject()));
        this.connectionPage = new ConnectionPageWithAuth(){

            public void createControl(Composite parent) {
                super.createAuthPanel(parent, 1);
            }

            public Control getControl() {
                return super.getAuthPanelComposite();
            }

            protected DBPConnectionEditIntention getIntention() {
                return DBPConnectionEditIntention.CREDENTIALS_ONLY;
            }
        };
        this.connectionPage.setSite((IDataSourceConnectionEditorSite)this);
        if (!this.dataSourceContainer.isSharedCredentials()) {
            DBPConnectionConfiguration cfg = dataSourceContainer.getConnectionConfiguration();
            DBWNetworkProfile activeProfile = DBWUtils.getNetworkProfile((DBPDataSourceContainer)dataSourceContainer);
            this.handlerConfigurators = cfg.getHandlers().stream().filter(DBWHandlerConfiguration::isEnabled).map(c -> Pair.of((Object)c, EditConnectionCredentialsDialog.createConfiguratorForHandler(c, activeProfile))).filter(p -> p.getSecond() != null).toList();
        } else {
            this.handlerConfigurators = Collections.emptyList();
        }
    }

    private static IObjectPropertyConfigurator<Object, DBWHandlerConfiguration> createConfiguratorForHandler(@NotNull DBWHandlerConfiguration handlerConfiguration, @Nullable DBWNetworkProfile activeProfile) {
        try {
            DBWHandlerConfiguration profileConfig;
            DBWHandlerDescriptor handlerDescriptor = handlerConfiguration.getHandlerDescriptor();
            DBWHandlerConfiguration dBWHandlerConfiguration = profileConfig = activeProfile == null ? null : activeProfile.getConfiguration(handlerDescriptor);
            if (profileConfig != null && profileConfig.isEnabled()) {
                return new PlaceholderPropertyConfigurator<Object, DBWHandlerConfiguration>((parent, o) -> {
                    Control control = UIUtils.createWarningLabel((Composite)parent, (String)(handlerConfiguration.getTitle() + " provided by the " + activeProfile.getProfileName() + " profile"), (int)1808, (int)1);
                });
            }
            String implName = handlerDescriptor.getImplClassName();
            UIPropertyConfiguratorDescriptor configDescriptor = UIPropertyConfiguratorRegistry.getInstance().getDescriptor(implName);
            if (configDescriptor != null) {
                IObjectPropertyConfigurator configurator = configDescriptor.createConfigurator();
                if (configurator instanceof AbstractObjectPropertyConfigurator) {
                    AbstractObjectPropertyConfigurator abstractConfigurator = (AbstractObjectPropertyConfigurator)configurator;
                    abstractConfigurator.setEditIntention(DBPConnectionEditIntention.CREDENTIALS_ONLY);
                }
                return configurator;
            }
            log.debug((Object)("No configurator for " + handlerConfiguration.getTitle()));
            return null;
        }
        catch (DBException dBException) {
            return new PlaceholderPropertyConfigurator<Object, DBWHandlerConfiguration>((parent, o) -> {
                Control control = UIUtils.createWarningLabel((Composite)parent, (String)("Failed to create configurator for " + handlerConfiguration.getTitle()), (int)1808, (int)1);
            });
        }
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        this.connectionPage.createControl(composite);
        for (Pair<DBWHandlerConfiguration, IObjectPropertyConfigurator<Object, DBWHandlerConfiguration>> pcp : this.handlerConfigurators) {
            Section section = new Section(composite, 66);
            section.setText(((DBWHandlerConfiguration)pcp.getFirst()).getTitle());
            section.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            Composite contents = UIUtils.createComposite((Composite)section, (int)1);
            section.setClient((Control)contents);
            ((IObjectPropertyConfigurator)pcp.getSecond()).createControl(contents, null, this.handlerChangedListener);
        }
        return composite;
    }

    public DBPDriver getDriver() {
        return this.dataSourceContainer.getDriver();
    }

    @NotNull
    public DBPDataSourceContainer getActiveDataSource() {
        return this.dataSourceContainer;
    }

    public void updateButtons() {
    }

    public boolean openDriverEditor() {
        return false;
    }

    public boolean openSettingsPage(String pageId) {
        return false;
    }

    public void testConnection() {
    }

    public RCPProject getProject() {
        return (RCPProject)this.dataSourceContainer.getProject();
    }

    public IWizard getWizard() {
        return null;
    }

    public void firePropertyChange(Object source, String property, Object oldValue, Object newValue) {
    }

    public DBRRunnableContext getRunnableContext() {
        return null;
    }

    @Nullable
    public DBPDataSourceRegistry getDataSourceRegistry() {
        return this.dataSourceContainer.getRegistry();
    }

    public boolean isNew() {
        return false;
    }

    protected void okPressed() {
        if (this.dataSourceContainer.isSharedCredentials()) {
            super.okPressed();
            return;
        }
        if (this.connectionPage.isComplete() && this.handlerConfigurators.stream().allMatch(c -> ((IObjectPropertyConfigurator)c.getSecond()).isComplete())) {
            this.connectionPage.saveSettings(this.dataSourceContainer);
            this.handlerConfigurators.forEach(c -> ((IObjectPropertyConfigurator)c.getSecond()).saveSettings((Object)((DBWHandlerConfiguration)c.getFirst())));
            DBPProject project = this.dataSourceContainer.getProject();
            if (project.isUseSecretStorage()) {
                try {
                    this.dataSourceContainer.persistSecrets(DBSSecretController.getProjectSecretController((DBPProject)this.dataSourceContainer.getProject()));
                    super.okPressed();
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError("Datasource credentials update error", "Error updating datasource credentials", (Throwable)e);
                }
            }
        } else {
            DBWorkbench.getPlatformUI().showWarningMessageBox(TeamMessages.edit_connection_credentials_incomplete_warning_title, TeamMessages.edit_connection_credentials_incomplete_warning_message);
        }
    }

    void loadSettings() {
        this.connectionPage.loadSettings();
        this.handlerConfigurators.forEach(c -> ((IObjectPropertyConfigurator)c.getSecond()).loadSettings((Object)((DBWHandlerConfiguration)c.getFirst())));
        this.initializeBounds();
    }

    private static class PlaceholderPropertyConfigurator<OBJECT, SETTINGS>
    implements IObjectPropertyConfigurator<OBJECT, SETTINGS> {
        private final BiConsumer<Composite, OBJECT> uiBuilder;

        public PlaceholderPropertyConfigurator(BiConsumer<Composite, OBJECT> uiBuilder) {
            this.uiBuilder = uiBuilder;
        }

        public void createControl(@NotNull Composite parent, OBJECT object, @NotNull Runnable propertyChangeListener) {
            this.uiBuilder.accept(parent, object);
        }

        public void loadSettings(@NotNull SETTINGS settings) {
        }

        public void saveSettings(@NotNull SETTINGS settings) {
        }

        public void resetSettings(@NotNull SETTINGS settings) {
        }

        public boolean isComplete() {
            return true;
        }
    }
}

