/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.team.auth;

import com.dbeaver.ee.runtime.auth.URLCallback;
import com.dbeaver.model.auth.SMServerAPI;
import com.dbeaver.model.auth.SMSessionRemote;
import com.dbeaver.model.secret.SecretControllerRegistry;
import com.dbeaver.remote.client.AbstractRemoteClientConfiguration;
import com.dbeaver.remote.client.dc.DCClientConfiguration;
import com.dbeaver.remote.client.dc.DCRemoteSecurityController;
import com.dbeaver.remote.client.dc.DCSecretControllerRemote;
import com.dbeaver.team.auth.DCSessionAbstract;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import org.eclipse.core.runtime.IAdaptable;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.auth.SMAuthInfo;
import org.jkiss.dbeaver.model.auth.SMAuthSpace;
import org.jkiss.dbeaver.model.auth.SMCredentials;
import org.jkiss.dbeaver.model.auth.SMCredentialsProvider;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.auth.SMSessionContext;
import org.jkiss.dbeaver.model.auth.SMSessionPrincipal;
import org.jkiss.dbeaver.model.auth.SMSessionSecretKeeper;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.dbeaver.model.security.SMAdminController;
import org.jkiss.dbeaver.model.security.SMController;
import org.jkiss.dbeaver.model.security.SMTokens;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class DCSessionGlobal
extends DCSessionAbstract
implements SMSessionRemote,
SMSessionPrincipal,
SMSessionSecretKeeper,
IAdaptable {
    private static final Log log = Log.getLog(DCSessionGlobal.class);
    @NotNull
    private final DBPWorkspace workspace;
    @NotNull
    private final DCClientConfiguration clientConfig;
    @NotNull
    private final SMServerAPI serverApiInfo;
    @NotNull
    private final CallbackHandler callbackHandler;
    @NotNull
    private final SMController smController;
    private final DBSSecretController secretController;
    private Map<String, SMAuthInfo> extraAuthInfo;
    @Nullable
    private volatile SMAdminController adminController;
    private final SMCredentialsProvider credentialsProvider = new SMCredentialsProvider(){

        @Nullable
        public SMCredentials getActiveUserCredentials() {
            if (DCSessionGlobal.this.dcTokens == null) {
                return null;
            }
            return new SMCredentials(DCSessionGlobal.this.dcTokens.getSmAccessToken(), DCSessionGlobal.this.dcAuthInfo.getAuthPermissions().getUserId(), DCSessionGlobal.this.dcAuthInfo.getAuthPermissions().getSessionId(), DCSessionGlobal.this.dcAuthInfo.getAuthPermissions().getPermissions());
        }

        public synchronized void refreshSMSession() throws DBException {
            if (DCSessionGlobal.this.dcTokens == null) {
                return;
            }
            log.debug((Object)"Refreshing SM session");
            DCSessionGlobal.this.dcTokens = DCSessionGlobal.this.smController.refreshSession(DCSessionGlobal.this.dcTokens.getSmRefreshToken());
        }
    };

    public DCSessionGlobal(@NotNull DBPWorkspace workspace, @NotNull DCClientConfiguration clientConfig, @NotNull SMAuthInfo dcAuthInfo, @Nullable SMTokens dcTokens, @NotNull SMServerAPI apiInfo, @NotNull CallbackHandler callbackHandler) throws DBException {
        super(dcAuthInfo, dcTokens);
        this.workspace = workspace;
        this.clientConfig = clientConfig;
        this.serverApiInfo = apiInfo;
        this.callbackHandler = callbackHandler;
        SMCredentialsProvider credentialsProvider = this.getRemoteCredentialsProvider();
        DCClientConfiguration dcClientConfig = ((DCClientConfiguration.Builder)((DCClientConfiguration.Builder)((DCClientConfiguration.Builder)DCClientConfiguration.builder().from((AbstractRemoteClientConfiguration)clientConfig)).setCredentialsProvider(credentialsProvider)).setRefreshSMSessionFunction(() -> ((SMCredentialsProvider)credentialsProvider).refreshSMSession())).setServerAPI(this.serverApiInfo).build();
        this.smController = new DCRemoteSecurityController(dcClientConfig);
        this.secretController = !CommonUtils.isEmpty((String)apiInfo.getSecretController()) && !apiInfo.getSecretController().startsWith("dc-") ? SecretControllerRegistry.getInstance().getAuthorizedSecretController(apiInfo.getSecretController(), credentialsProvider, this.workspace.getAuthContext()) : new DCSecretControllerRemote(dcClientConfig);
    }

    @NotNull
    public SMAuthSpace getSessionSpace() {
        return this.workspace;
    }

    @NotNull
    public SMSessionContext getSessionContext() {
        return this.workspace.getAuthContext();
    }

    @Nullable
    public SMSessionPrincipal getSessionPrincipal() {
        return this;
    }

    public String getUserDomain() {
        return null;
    }

    public String getUserName() {
        return this.dcAuthInfo.getAuthPermissions().getUserId();
    }

    public String getRemoteServiceURL() {
        return this.clientConfig.getApiUrl();
    }

    public SMCredentialsProvider getRemoteCredentialsProvider() {
        return this.credentialsProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getAdapter(@NotNull Class<T> adapter) {
        if (adapter == SMController.class) {
            return adapter.cast(this.smController);
        }
        if (adapter == SMAdminController.class && this.credentialsProvider.hasPermission("admin")) {
            if (this.adminController == null) {
                DCSessionGlobal dCSessionGlobal = this;
                synchronized (dCSessionGlobal) {
                    if (this.adminController == null) {
                        DCClientConfiguration clientConfig = DCClientConfiguration.builder((SMSessionRemote)this).build();
                        this.adminController = new DCRemoteSecurityController(clientConfig);
                    }
                }
            }
            return adapter.cast(this.adminController);
        }
        if (adapter == DCClientConfiguration.class) {
            return adapter.cast(this.clientConfig);
        }
        if (adapter == SMServerAPI.class) {
            return adapter.cast(this.serverApiInfo);
        }
        return super.getAdapter(adapter);
    }

    @Override
    public void close() {
        block7: {
            if (!CommonUtils.isEmpty((String)this.dcAuthInfo.getSignOutLink())) {
                try {
                    this.callbackHandler.handle(new Callback[]{new URLCallback(this.dcAuthInfo.getSignOutLink())});
                }
                catch (Exception e) {
                    log.debug((Object)e);
                }
            }
            try {
                if (this.dcTokens == null) break block7;
                try {
                    DBWorkbench.getPlatform().getPreferenceStore().save();
                }
                catch (Exception e) {
                    log.debug((Object)"Error saving user preferences to server", (Throwable)e);
                }
                this.smController.logout();
            }
            catch (Exception e) {
                log.error((Object)"Error closing remote DC session", (Throwable)e);
            }
        }
        super.close();
    }

    @Nullable
    public DBSSecretController getSecretController() {
        return this.secretController;
    }

    public List<SMAuthInfo> getAuthInfos() {
        if (this.extraAuthInfo == null) {
            return Collections.singletonList(this.dcAuthInfo);
        }
        ArrayList<SMAuthInfo> infos = new ArrayList<SMAuthInfo>();
        infos.add(this.dcAuthInfo);
        infos.addAll(this.extraAuthInfo.values());
        return infos;
    }

    @NotNull
    public SMServerAPI getServerApi() {
        return this.serverApiInfo;
    }

    public boolean aggregateSubSession(@NotNull String authProviderId, @NotNull SMSession subSession) {
        SMAuthInfo eai = (SMAuthInfo)DBUtils.getAdapter(SMAuthInfo.class, (Object)subSession);
        if (eai != null) {
            if (this.extraAuthInfo == null) {
                this.extraAuthInfo = new LinkedHashMap<String, SMAuthInfo>();
            }
            this.extraAuthInfo.put(authProviderId, eai);
            return true;
        }
        return false;
    }
}

