/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.team.auth;

import com.dbeaver.lm.api.LMRole;
import com.dbeaver.model.auth.SMApplicationIdentityProvider;
import com.dbeaver.model.auth.SMAuthProcessInteractive;
import com.dbeaver.model.auth.SMAuthPromptConfiguration;
import com.dbeaver.model.auth.SMClientUtils;
import com.dbeaver.model.auth.SMServerAPI;
import com.dbeaver.model.auth.SMSessionRemote;
import com.dbeaver.remote.client.dc.DCClientConfiguration;
import com.dbeaver.remote.client.dc.DCRemoteSecurityController;
import com.dbeaver.team.auth.DCConfiguration;
import com.dbeaver.team.auth.DCSessionFederated;
import com.dbeaver.team.auth.DCSessionGlobal;
import com.dbeaver.team.auth.DCWebsocketAuth;
import com.dbeaver.team.ui.AuthProgressDialog;
import com.dbeaver.team.ui.TeamAuthUI;
import com.google.gson.Gson;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import jakarta.websocket.ClientEndpointConfig;
import jakarta.websocket.Endpoint;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.security.auth.callback.CallbackHandler;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpProxy;
import org.eclipse.jetty.client.ProxyConfiguration;
import org.eclipse.jetty.ee10.websocket.jakarta.client.JakartaWebSocketClientContainer;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.auth.AuthPropertyDescriptor;
import org.jkiss.dbeaver.model.auth.AuthPropertyEncryption;
import org.jkiss.dbeaver.model.auth.SMAuthInfo;
import org.jkiss.dbeaver.model.auth.SMAuthStatus;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.impl.app.BaseWorkspaceImpl;
import org.jkiss.dbeaver.model.impl.app.LocalWorkspaceSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.security.SMAuthCredentialsProfile;
import org.jkiss.dbeaver.model.security.SMAuthProviderCustomConfiguration;
import org.jkiss.dbeaver.model.security.SMAuthProviderDescriptor;
import org.jkiss.dbeaver.model.security.SMTokens;
import org.jkiss.dbeaver.model.websocket.WSUtils;
import org.jkiss.dbeaver.runtime.DBInterruptedException;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.WSClientUtils;

public class DCIdentityProvider
implements SMApplicationIdentityProvider {
    private static final Log log = Log.getLog(DCIdentityProvider.class);
    private static final String PROP_DC_SERVER_URL = "DBEAVER_DOMAIN_CONTROLLER";
    private static final String PROP_REGISTRY_DBEAVER = "Software\\DBeaverTeam";
    private static final String PROP_REGISTRY_SERVER_URL = "DomainControllerURL";
    public static final String DC_CONFIG_FILE = "domain-controller.properties";
    public static final String CRED_CONFIG_FILE = ".last-prompt-credentials.json";
    private static final int[] DEFAULT_DC_PORTS;
    private static final String[] DEFAULT_DC_PROTOCOLS;
    private static final String PROP_DOMAIN_CONTROLLER = "domain_controller";
    private static final String PROP_SERVERS = "servers";
    public static final String DC_SERVICE_URI_PREFIX = "/dc";
    private final DCConfiguration dcConfiguration = new DCConfiguration();
    private String serverEndpoint;
    private SMServerAPI serverInfo;
    private SMAuthPromptConfiguration promptConfiguration;
    private volatile JakartaWebSocketClientContainer webSocketContainer;

    static {
        int[] nArray = new int[2];
        nArray[1] = 8970;
        DEFAULT_DC_PORTS = nArray;
        DEFAULT_DC_PROTOCOLS = new String[]{"https", "http"};
    }

    public boolean isDefaultForCurrentEnvironment() {
        return true;
    }

    private boolean detectDomainControllerEndpoint(DBPWorkspace workspace) throws DBException {
        String dcURL;
        this.loadDomainControllerProperties(workspace);
        if (this.dcConfiguration.isComplete()) {
            return true;
        }
        this.dcConfiguration.setDomainControllerURL(RuntimeUtils.getSystemPropertyIgnoreCase((String)PROP_DC_SERVER_URL));
        if (this.dcConfiguration.isComplete()) {
            return true;
        }
        this.dcConfiguration.setDomainControllerURL(RuntimeUtils.getSystemEnvIgnoreCase((String)PROP_DC_SERVER_URL));
        if (this.dcConfiguration.isComplete()) {
            return true;
        }
        if (RuntimeUtils.isWindows() && (dcURL = DCIdentityProvider.getAddressFromRegistry()) != null) {
            this.dcConfiguration.setDomainControllerURL(dcURL);
        }
        return this.dcConfiguration.isComplete();
    }

    private static String getAddressFromRegistry() {
        String dcURL;
        if (Advapi32Util.registryKeyExists((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)PROP_REGISTRY_DBEAVER) && !CommonUtils.isEmptyTrimmed((String)(dcURL = CommonUtils.toString((Object)Advapi32Util.registryGetValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)PROP_REGISTRY_DBEAVER, (String)PROP_REGISTRY_SERVER_URL), null)))) {
            return dcURL.trim();
        }
        if (Advapi32Util.registryKeyExists((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)PROP_REGISTRY_DBEAVER) && !CommonUtils.isEmptyTrimmed((String)(dcURL = CommonUtils.toString((Object)Advapi32Util.registryGetValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)PROP_REGISTRY_DBEAVER, (String)PROP_REGISTRY_SERVER_URL), null)))) {
            return dcURL.trim();
        }
        return null;
    }

    @NotNull
    public SMSession acquireApplicationSession(@NotNull DBRProgressMonitor monitor, @NotNull String authTitle, @Nullable SMSession mainSession, @NotNull DBPWorkspace workspace, @NotNull CallbackHandler handler) throws DBException {
        boolean saveDcConfig = false;
        boolean isServerURLDetected = this.detectDomainControllerEndpoint(workspace);
        if (isServerURLDetected && this.getValidServerURL(this.dcConfiguration.getDomainControllerURL()) == null) {
            TeamAuthUI.showInformationMessage(1, "Server is not accessible at " + this.dcConfiguration.getDomainControllerURL() + ".\nPlease ask your administrator or enter another server URL.");
            isServerURLDetected = false;
        }
        if (!isServerURLDetected) {
            String validServerURL;
            while (true) {
                String serverURL;
                if ((serverURL = TeamAuthUI.showParameterPrompt(this.dcConfiguration.getDomainControllerURL())) == null) {
                    throw new DBInterruptedException("No server endpoint");
                }
                validServerURL = this.getValidServerURL(serverURL);
                if (validServerURL != null) break;
                TeamAuthUI.showInformationMessage(1, "Invalid server endpoint: " + serverURL);
            }
            this.dcConfiguration.setDomainControllerURL(validServerURL);
            saveDcConfig = true;
            if (!this.dcConfiguration.isComplete()) {
                throw new DBException("Empty DC endpoint");
            }
        }
        String localhostId = BaseWorkspaceImpl.getLocalHostId();
        String dcURL = DCIdentityProvider.normalizeServerURL(this.dcConfiguration.getDomainControllerURL());
        while (true) {
            SMAuthProviderDescriptor[] authProviders;
            DCClientConfiguration.Builder configurationBuilder = (DCClientConfiguration.Builder)DCClientConfiguration.builder().setServerAPI(this.serverInfo).setApiUrl(dcURL);
            if (mainSession instanceof SMSessionRemote) {
                SMSessionRemote mainRemoteSession = (SMSessionRemote)mainSession;
                configurationBuilder.setCredentialsProvider(mainRemoteSession.getRemoteCredentialsProvider());
            } else if (mainSession != null) {
                throw new DBException("Cannot acquire not remote session");
            }
            DCClientConfiguration clientConfig = configurationBuilder.build();
            final DCRemoteSecurityController svc = new DCRemoteSecurityController(clientConfig);
            try {
                authProviders = svc.getAvailableAuthProviders();
            }
            catch (Exception e) {
                throw new DBException("Can't contact with remote DC server: " + e.getMessage(), (Throwable)e);
            }
            this.promptConfiguration = new SMAuthPromptConfiguration(this.serverInfo, authProviders, null, Map.of());
            this.promptConfiguration.setAuthTitle(authTitle);
            this.promptConfiguration.setMainSession(mainSession);
            this.loadLastSavedConfiguration(this.promptConfiguration, workspace);
            this.promptConfiguration = TeamAuthUI.doProviderAuthentication(this.promptConfiguration, this.dcConfiguration);
            if (this.dcConfiguration.getNewServerURL() != null) {
                dcURL = this.dcConfiguration.getNewServerURL();
                try {
                    this.serverInfo = this.tryServerAccessible(dcURL);
                }
                catch (DBException e) {
                    TeamAuthUI.showInformationMessage(1, e.getMessage());
                    continue;
                }
                this.dcConfiguration.getOtherServers().addFirst(this.dcConfiguration.getDomainControllerURL());
                this.dcConfiguration.getOtherServers().remove(dcURL);
                this.dcConfiguration.setDomainControllerURL(dcURL);
                saveDcConfig = true;
                continue;
            }
            LinkedHashMap sessionParams = new LinkedHashMap();
            LinkedHashMap<String, String> userCredentials = new LinkedHashMap<String, String>(this.promptConfiguration.getAuthCredentials());
            SMAuthCredentialsProfile credProfile = this.promptConfiguration.getSelectedProfile();
            for (AuthPropertyDescriptor prop : credProfile.getCredentialParameters()) {
                Object propValue;
                if (prop.getEncryption() == AuthPropertyEncryption.none || (propValue = userCredentials.get(prop.getId())) == null) continue;
                String encValue = prop.getEncryption().encrypt("", String.valueOf(propValue));
                userCredentials.put(prop.getId(), encValue);
            }
            if (mainSession == null) {
                this.savePromptConfiguration(this.promptConfiguration, workspace);
            }
            String appSessionId = this.serverInfo.getApplicationWorkspaceId() + "-" + localhostId;
            try {
                final SMAuthInfo dcAuthInfo = svc.authenticate(appSessionId, mainSession == null ? null : mainSession.getSessionId(), sessionParams, LocalWorkspaceSession.DB_SESSION_TYPE, this.promptConfiguration.getSelectedProviderId(), this.promptConfiguration.getSelectedConfigurationId(), userCredentials, false);
                final SMAuthInfo[] finalAuthInfo = new SMAuthInfo[]{dcAuthInfo};
                switch (dcAuthInfo.getAuthStatus()) {
                    case ERROR: {
                        throw new DBException(dcAuthInfo.getError());
                    }
                    case IN_PROGRESS: {
                        SMAuthProviderCustomConfiguration cc = this.promptConfiguration.getSelectedCustomConfiguration();
                        SMAuthProcessInteractive<SMAuthInfo> api = new SMAuthProcessInteractive<SMAuthInfo>("Federated authorization (" + cc.getDisplayName() + ")", "Perform federated authorization in web browser", null, dcAuthInfo){

                            public boolean checkForCompletion(DBRProgressMonitor monitor) throws DBException {
                                if (this.isCanceled()) {
                                    return true;
                                }
                                if (dcAuthInfo.getAuthAttemptId() == null) {
                                    throw new DBException("Auth attempt missing");
                                }
                                if (this.isLegacyAuth()) {
                                    SMAuthInfo newStatus = svc.getAuthStatus(dcAuthInfo.getAuthAttemptId());
                                    this.setResult(newStatus);
                                }
                                if (this.getError() != null) {
                                    Throwable error = this.getError();
                                    throw new DBException("Auth error: " + error.getMessage(), error);
                                }
                                switch (((SMAuthInfo)this.getResult()).getAuthStatus()) {
                                    case IN_PROGRESS: {
                                        return false;
                                    }
                                    case ERROR: {
                                        throw new DBException(((SMAuthInfo)this.getResult()).getError());
                                    }
                                }
                                finalAuthInfo[0] = (SMAuthInfo)this.getResult();
                                return true;
                            }
                        };
                        if (SMClientUtils.isServerLegacy((SMServerAPI)this.serverInfo, (String)"25.0.2")) {
                            api.setLegacyAuth(true);
                        } else {
                            try {
                                this.connectAuthSocket(api, dcAuthInfo, this.dcConfiguration);
                            }
                            catch (DBException e) {
                                log.error((Object)"Failed to connect to the DC authorization socket, use legacy auth mechanism", (Throwable)e);
                                api.setLegacyAuth(true);
                            }
                        }
                        api.setUpdatePeriod(2000);
                        api.setAuthenticationURL(dcAuthInfo.getRedirectUrl());
                        try {
                            AuthProgressDialog dialog = new AuthProgressDialog(TeamAuthUI.getActiveShell(), api);
                            dialog.open();
                        }
                        catch (Exception e) {
                            throw new DBException(e.getMessage(), (Throwable)e);
                        }
                        if (finalAuthInfo[0].getAuthStatus() == SMAuthStatus.SUCCESS) break;
                        throw new DBException("Authentication has been canceled");
                    }
                }
                if (saveDcConfig && mainSession == null) {
                    this.saveDomainControllerProperties(workspace);
                }
                SMAuthInfo authInfo = finalAuthInfo[0];
                if (mainSession == null) {
                    LMRole role = (LMRole)CommonUtils.valueOf(LMRole.class, (String)authInfo.getAuthRole());
                    if (role == null) {
                        throw new DBException("No license role assigned to user " + authInfo.getAuthPermissions().getUserId());
                    }
                    if (role == LMRole.VIEWER) {
                        throw new DBException("Viewer role is not supported in desktop application");
                    }
                    if (role == LMRole.EDITOR) {
                        throw new DBException("Editor role is not supported in desktop application");
                    }
                }
                SMTokens dcTokens = null;
                if (authInfo.getAuthStatus() == SMAuthStatus.SUCCESS) {
                    dcTokens = new SMTokens(authInfo.getSmAccessToken(), authInfo.getSmRefreshToken());
                }
                if (this.webSocketContainer != null && this.webSocketContainer.isStarted()) {
                    try {
                        this.webSocketContainer.stop();
                    }
                    catch (Exception e) {
                        log.error((Object)"Failed to stop auth web socket container", (Throwable)e);
                    }
                }
                if (mainSession instanceof DCSessionGlobal) {
                    DCSessionGlobal sg = (DCSessionGlobal)mainSession;
                    return new DCSessionFederated(sg, finalAuthInfo[0], dcTokens);
                }
                DCSessionGlobal globalSession = new DCSessionGlobal(workspace, clientConfig, finalAuthInfo[0], dcTokens, this.serverInfo, handler);
                return globalSession;
            }
            catch (DBException e) {
                this.handleAuthError(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectAuthSocket(@NotNull SMAuthProcessInteractive<SMAuthInfo> api, @NotNull SMAuthInfo dcAuthInfo, @NotNull DCConfiguration dcConfiguration) throws DBException {
        try {
            ClientEndpointConfig clientEndpointConfig = ClientEndpointConfig.Builder.create().configurator((ClientEndpointConfig.Configurator)new DCWebsocketAuth.Configurator(dcAuthInfo.getAuthAttemptId())).build();
            DCIdentityProvider dCIdentityProvider = this;
            synchronized (dCIdentityProvider) {
                if (this.webSocketContainer == null || !this.webSocketContainer.isStarted()) {
                    HttpClient httpClient = new HttpClient();
                    WSClientUtils.ProxyInfo proxyInfo = WSClientUtils.findProxyInfo();
                    if (proxyInfo.exists()) {
                        httpClient.getProxyConfiguration().addProxy((ProxyConfiguration.Proxy)new HttpProxy(proxyInfo.getHost(), proxyInfo.getPort()));
                    }
                    this.webSocketContainer = new JakartaWebSocketClientContainer(httpClient);
                    this.webSocketContainer.start();
                }
            }
            URI dcUri = URI.create(dcConfiguration.getDomainControllerURL());
            URI authUri = URI.create(dcConfiguration.getDomainControllerURL()).resolve(dcUri.getPath() + "/ws/auth");
            authUri = WSUtils.convertUriToWS((URI)authUri);
            this.webSocketContainer.connectToServer((Endpoint)new DCWebsocketAuth(api), clientEndpointConfig, authUri);
        }
        catch (Exception e) {
            throw new DBException("Failed to connect auth websocket: " + e.getMessage(), (Throwable)e);
        }
    }

    public void handleAuthError(@NotNull DBException e) {
        DBWorkbench.getPlatformUI().showMessageBox("Authentication error", e.getMessage(), true);
    }

    @NotNull
    private static String normalizeServerURL(String serverURL) throws DBException {
        return DCIdentityProvider.normalizeServerURL(serverURL, true);
    }

    public static String normalizeServerURL(String serverURL, boolean useHttps) throws DBException {
        int divPos;
        Object dcURL = serverURL;
        if (!((String)dcURL).startsWith("http://") && !((String)dcURL).startsWith("https://")) {
            dcURL = (useHttps ? "https" : "http") + "://" + (String)dcURL;
        }
        if ((divPos = ((String)dcURL).indexOf(35)) != -1) {
            dcURL = ((String)dcURL).substring(0, divPos);
        }
        try {
            URL url = new URL((String)dcURL);
            if (CommonUtils.isEmpty((String)url.getPath()) || "/".equals(url.getPath())) {
                while (((String)dcURL).endsWith("/")) {
                    dcURL = ((String)dcURL).substring(0, ((String)dcURL).length() - 1);
                }
                dcURL = (String)dcURL + DC_SERVICE_URI_PREFIX;
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new DBException("Invalid domain controller URL");
        }
        return dcURL;
    }

    public String getValidServerURL(String serverURL) {
        try {
            String normalizedServerURL = DCIdentityProvider.normalizeServerURL(serverURL);
            try {
                this.tryServerAccessible(normalizedServerURL);
            }
            catch (DBException e) {
                if (!serverURL.contains("://") && normalizedServerURL.startsWith("https://") && CommonUtils.hasCause((Throwable)e, IOException.class)) {
                    normalizedServerURL = DCIdentityProvider.normalizeServerURL(serverURL, false);
                    this.tryServerAccessible(normalizedServerURL);
                }
                throw e;
            }
            return normalizedServerURL;
        }
        catch (Exception e) {
            log.debug((Object)("Error validating server endpoint '" + serverURL + "': " + e.getMessage()));
            return null;
        }
    }

    @NotNull
    private SMServerAPI tryServerAccessible(String normalizedServerURL) throws DBException {
        if (this.serverInfo != null && Objects.equals(this.serverEndpoint, normalizedServerURL)) {
            return this.serverInfo;
        }
        DCClientConfiguration clientConfig = ((DCClientConfiguration.Builder)DCClientConfiguration.builder().setApiUrl(normalizedServerURL)).build();
        DCRemoteSecurityController svc = new DCRemoteSecurityController(clientConfig);
        this.serverInfo = svc.getServerAPI();
        this.serverEndpoint = normalizedServerURL;
        return this.serverInfo;
    }

    private void loadDomainControllerProperties(DBPWorkspace workspace) {
        Path configFile = workspace.getMetadataFolder().resolve(DC_CONFIG_FILE);
        if (!Files.exists(configFile, new LinkOption[0])) {
            return;
        }
        Properties props = new Properties();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedReader in = Files.newBufferedReader(configFile);){
                props.load(in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.debug((Object)e);
            return;
        }
        this.dcConfiguration.setDomainControllerURL(this.getValidServerURL(props.getProperty(PROP_DOMAIN_CONTROLLER)));
        String serversStr = props.getProperty(PROP_SERVERS);
        if (!CommonUtils.isEmpty((String)serversStr)) {
            this.dcConfiguration.getOtherServers().addAll(Arrays.stream(serversStr.split(",")).toList());
        }
    }

    private void saveDomainControllerProperties(DBPWorkspace workspace) {
        Path configFile = workspace.getMetadataFolder().resolve(DC_CONFIG_FILE);
        Properties props = new Properties();
        props.put(PROP_DOMAIN_CONTROLLER, this.dcConfiguration.getDomainControllerURL());
        List<String> otherServers = this.dcConfiguration.getOtherServers();
        if (!CommonUtils.isEmpty(otherServers)) {
            props.put(PROP_SERVERS, String.join((CharSequence)",", otherServers));
        }
        this.dcConfiguration.setDomainControllerURL(props.getProperty(PROP_DOMAIN_CONTROLLER));
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (BufferedWriter out = Files.newBufferedWriter(configFile, new OpenOption[0]);){
                props.store(out, "Domain controller configuration");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.debug((Object)e);
        }
    }

    private void savePromptConfiguration(SMAuthPromptConfiguration configuration, DBPWorkspace workspace) {
        LinkedHashMap<String, Object> nonSecureCredentials = new LinkedHashMap<String, Object>();
        SMAuthCredentialsProfile selectedProfile = configuration.getSelectedProfile();
        if (selectedProfile != null) {
            for (AuthPropertyDescriptor prop : selectedProfile.getCredentialParameters()) {
                if (prop.getEncryption() != AuthPropertyEncryption.none) continue;
                nonSecureCredentials.put(prop.getId(), configuration.getAuthCredentials().get(prop.getId()));
            }
        }
        Path configFile = workspace.getMetadataFolder().resolve(CRED_CONFIG_FILE);
        try {
            Object object = null;
            Object var7_9 = null;
            try (BufferedWriter out = Files.newBufferedWriter(configFile, new OpenOption[0]);){
                Gson gson = new Gson();
                SavedPromptConfiguration cfg = new SavedPromptConfiguration();
                cfg.selectedProviderId = configuration.getSelectedProviderId();
                cfg.selectedProfileId = configuration.getSelectedProfileId();
                cfg.selectedConfigurationId = configuration.getSelectedConfigurationId();
                cfg.properties = nonSecureCredentials;
                out.write(gson.toJson((Object)cfg));
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                } else if (object != throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                throw object;
            }
        }
        catch (Exception e) {
            log.debug((Object)"Error reading saved credentials", (Throwable)e);
        }
    }

    private void loadLastSavedConfiguration(SMAuthPromptConfiguration configuration, DBPWorkspace workspace) {
        Path configFile = workspace.getMetadataFolder().resolve(CRED_CONFIG_FILE);
        if (!Files.exists(configFile, new LinkOption[0])) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedReader in = Files.newBufferedReader(configFile);){
                Gson gson = new Gson();
                SavedPromptConfiguration cfg = (SavedPromptConfiguration)gson.fromJson((Reader)in, SavedPromptConfiguration.class);
                configuration.setSelectedProviderId(cfg.selectedProviderId);
                configuration.setSelectedProfileId(cfg.selectedProfileId);
                configuration.setSelectedConfigurationId(cfg.selectedConfigurationId);
                if (cfg.properties != null) {
                    configuration.setAuthCredentials(cfg.properties);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.debug((Object)"Error reading saved credentials", (Throwable)e);
        }
    }

    public static class SavedPromptConfiguration {
        String selectedProviderId;
        String selectedProfileId;
        String selectedConfigurationId;
        Map<String, Object> properties;
    }
}

