/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.team.application;

import com.dbeaver.application.EnterpriseWorkbenchAdvisor;
import com.dbeaver.team.application.TeamWorkbenchWindowAdvisor;
import com.dbeaver.team.application.internal.TeamAppMessages;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.app.standalone.ApplicationWorkbenchAdvisor;
import org.jkiss.utils.ArrayUtils;

public class TeamWorkbenchAdvisor
extends EnterpriseWorkbenchAdvisor {
    private static final Log log = Log.getLog(TeamWorkbenchAdvisor.class);
    private static final String[] EXCLUDE_PREF_PAGES = new String[]{"org.eclipse.team.ui.TeamPreferences", "org.eclipse.ui.preferencePages.Workbench/com.dbeaver.ee.runtime.ui.preferencePages.page.security", "org.eclipse.debug.ui.DebugPreferencePage", "org.eclipse.ui.preferencePages.Workbench/org.eclipse.ui.preferencePages.Perspectives", "org.eclipse.ui.preferencePages.Workbench/org.eclipse.ui.preferencePages.Workspace", "org.eclipse.ui.preferencePages.Workbench/org.jkiss.dbeaver.preferences.misc.qm/com.dbeaver.ee.qmdb.persistence"};

    public TeamWorkbenchAdvisor(DBPApplication application) {
        super(application);
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        super.initialize(configurer);
    }

    @NotNull
    protected String[] getExcludedPreferencePageIds() {
        return (String[])ArrayUtils.concatArrays((Object[])super.getExcludedPreferencePageIds(), (Object[])EXCLUDE_PREF_PAGES);
    }

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        return new TeamWorkbenchWindowAdvisor(this, configurer);
    }

    protected boolean isWizardAllowed(String wizardId) {
        return super.isWizardAllowed(wizardId);
    }

    public static void notifyUserDeletedAndShutdown() {
        UIUtils.showMessageBox(null, (String)TeamAppMessages.dialog_user_deleted_title, (String)TeamAppMessages.dialog_user_deleted_message, (int)8);
        TeamWorkbenchAdvisor.forceShutdown();
    }

    public static void notifyUserSessionClosedAndRestart() {
        UIUtils.showMessageBox(null, (String)TeamAppMessages.dialog_session_expired_force_title, (String)TeamAppMessages.dialog_session_expired_force_message, (int)8);
        TeamWorkbenchAdvisor.forceShutdown();
    }

    private static void forceShutdown() {
        try {
            ApplicationWorkbenchAdvisor.cancelRunningTasks((boolean)false);
            ApplicationWorkbenchAdvisor.closeActiveTransactions((boolean)true);
            IWorkbenchWindow window = UIUtils.getActiveWorkbenchWindow();
            ApplicationWorkbenchAdvisor.closeOpenEditors((IWorkbenchWindow)window, (boolean)false, (boolean)false);
            System.exit(1);
        }
        catch (Throwable e) {
            log.error((Object)"Error while shutting down", e);
            System.exit(-1);
        }
    }

    public static void notifyUserDisabledShutdown() {
        UIUtils.showMessageBox(null, (String)TeamAppMessages.dialog_user_disabled_force_title, (String)TeamAppMessages.dialog_user_disabled_force_message, (int)8);
        TeamWorkbenchAdvisor.forceShutdown();
    }
}

