/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.team.application;

import com.dbeaver.model.auth.SMSessionRemote;
import com.dbeaver.team.workspace.TeamWorkspaceImpl;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.registry.ApplicationPolicyProvider;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public final class TeamApplicationPolicyProvider
extends ApplicationPolicyProvider {
    private static final String PREF_DATA_EDITOR_IMPORT_DISABLED_OLD = "plugin.data-import.disabled";
    private static final String PREF_DATA_EDITOR_EXPORT_DISABLED_OLD = "plugin.data-viewer.export.disabled";
    private static final String PREF_DATA_EDITOR_COPY_DISABLED_OLD = "plugin.data-viewer.disableCopyData";
    private static final String PREF_DATA_EDITOR_EDITING_DISABLED_OLD = "plugin.data-viewer.disableEdit";
    private final Map<String, Policy> policies = Map.of("policy.sql.execution.disabled", new Policy.ModernPermission("permission.sql.script.execution", "25.1.4", true), "policy.data.import.disabled", new Policy.LegacyPreference("plugin.data-import.disabled", "permission.data-editor.import", "25.1.5", true), "policy.data.export.disabled", new Policy.LegacyPreference("plugin.data-viewer.export.disabled", "permission.data-editor.export", "25.1.5", true), "policy.data.copy.disabled", new Policy.LegacyPreference("plugin.data-viewer.disableCopyData", "permission.data-editor.copy", "25.1.5", true), "policy.data.edit.disabled", new Policy.LegacyPreference("plugin.data-viewer.disableEdit", "permission.data-editor.editing", "25.1.5", true));

    @Nullable
    public Object getPolicyProperty(@NotNull String property) {
        Policy policy = this.policies.get(property);
        if (policy != null) {
            TeamWorkspaceImpl workspace = (TeamWorkspaceImpl)((Object)DBUtils.getAdapter(TeamWorkspaceImpl.class, (Object)DBWorkbench.getPlatform().getWorkspace()));
            if (workspace == null) {
                return super.getPolicyProperty(property);
            }
            if (workspace.hasRealmPermission("admin")) {
                return !policy.defaultValue();
            }
            SMSessionRemote session = (SMSessionRemote)DBUtils.getAdapter(SMSessionRemote.class, (Object)workspace.getWorkspaceSession());
            if (session == null) {
                return super.getPolicyProperty(property);
            }
            Policy policy2 = policy;
            Objects.requireNonNull(policy2);
            Policy policy3 = policy2;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Policy.LegacyPreference.class, Policy.ModernPermission.class}, (Object)policy3, 0)) {
                case 0: {
                    Policy.LegacyPreference x = (Policy.LegacyPreference)policy3;
                    if (session.getServerApi().isServerVersionAtLeast(x.permissionSince())) {
                        return !workspace.hasRealmPermission(x.permissionKey());
                    }
                    Object value = workspace.getAppConfiguration().getProductConfiguration().get(x.preferenceKey());
                    if (value == null) {
                        return !x.defaultValue();
                    }
                    return CommonUtils.toBoolean(value);
                }
                case 1: {
                    Policy.ModernPermission x = (Policy.ModernPermission)policy3;
                    if (session.getServerApi().isServerVersionAtLeast(x.permissionSince())) {
                        return !workspace.hasRealmPermission(x.permissionKey());
                    }
                    return !x.defaultValue();
                }
            }
            throw new MatchException(null, null);
        }
        return super.getPolicyProperty(property);
    }

    private static sealed interface Policy {
        public boolean defaultValue();

        public record LegacyPreference(String preferenceKey, String permissionKey, String permissionSince, boolean defaultValue) implements Policy
        {
        }

        public record ModernPermission(String permissionKey, String permissionSince, boolean defaultValue) implements Policy
        {
        }
    }
}

