/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.gcp.bigtable;

import com.dbeaver.cloud.gcp.GCPCloudAbstractInstance;
import com.dbeaver.cloud.gcp.GCPCloudService;
import com.dbeaver.cloud.gcp.GCPCloudSession;
import com.dbeaver.cloud.gcp.GCPProject;
import com.google.api.services.bigtableadmin.v2.model.Instance;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;

public class GCPBigtableInstance
extends GCPCloudAbstractInstance {
    private final Instance instance;

    public GCPBigtableInstance(@NotNull GCPCloudSession session, @NotNull GCPProject project, @NotNull Instance instance) {
        super(session, project);
        this.instance = instance;
    }

    @NotNull
    public String getNodeId() {
        return this.instance.getDisplayName();
    }

    @NotNull
    public String getNodeName() {
        return this.instance.getDisplayName();
    }

    @Override
    protected void setDataSourceConfiguration(DataSourceDescriptor dataSource, DBPConnectionConfiguration configuration) {
        configuration.setServerName(this.instance.getDisplayName());
        configuration.setAuthModelId("gcp_cloud_iam_bigtable");
        configuration.setProviderProperty("projectId", this.getProject().getProjectId());
    }

    @Override
    protected GCPCloudService getCloudService() {
        return GCPCloudService.BIGTABLE;
    }

    @Override
    protected String getInstanceARN() {
        return this.instance.getName();
    }

    @Override
    protected String getExternalLink() {
        return "https://console.cloud.google.com/bigtable/instances/" + this.instance.getDisplayName() + "?project=" + this.getFolder().getFolderId();
    }

    @Nullable
    public String getInstanceEndpoint() {
        return null;
    }
}

