/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.resourcemanager.cosmos.models.DataTransferServiceResourceProperties;
import com.azure.resourcemanager.cosmos.models.GraphApiComputeServiceResourceProperties;
import com.azure.resourcemanager.cosmos.models.MaterializedViewsBuilderServiceResourceProperties;
import com.azure.resourcemanager.cosmos.models.ServiceSize;
import com.azure.resourcemanager.cosmos.models.ServiceStatus;
import com.azure.resourcemanager.cosmos.models.ServiceType;
import com.azure.resourcemanager.cosmos.models.SqlDedicatedGatewayServiceResourceProperties;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="serviceType", defaultImpl=ServiceResourceProperties.class, visible=true)
@JsonTypeName(value="ServiceResourceProperties")
@JsonSubTypes(value={@JsonSubTypes.Type(name="DataTransfer", value=DataTransferServiceResourceProperties.class), @JsonSubTypes.Type(name="SqlDedicatedGateway", value=SqlDedicatedGatewayServiceResourceProperties.class), @JsonSubTypes.Type(name="GraphAPICompute", value=GraphApiComputeServiceResourceProperties.class), @JsonSubTypes.Type(name="MaterializedViewsBuilder", value=MaterializedViewsBuilderServiceResourceProperties.class)})
public class ServiceResourceProperties {
    @JsonTypeId
    @JsonProperty(value="serviceType", required=true)
    private ServiceType serviceType = ServiceType.fromString("ServiceResourceProperties");
    @JsonProperty(value="creationTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime creationTime;
    @JsonProperty(value="instanceSize")
    private ServiceSize instanceSize;
    @JsonProperty(value="instanceCount")
    private Integer instanceCount;
    @JsonProperty(value="status", access=JsonProperty.Access.WRITE_ONLY)
    private ServiceStatus status;
    @JsonIgnore
    private Map<String, Object> additionalProperties;

    public ServiceType serviceType() {
        return this.serviceType;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public ServiceSize instanceSize() {
        return this.instanceSize;
    }

    public ServiceResourceProperties withInstanceSize(ServiceSize instanceSize) {
        this.instanceSize = instanceSize;
        return this;
    }

    public Integer instanceCount() {
        return this.instanceCount;
    }

    public ServiceResourceProperties withInstanceCount(Integer instanceCount) {
        this.instanceCount = instanceCount;
        return this;
    }

    public ServiceStatus status() {
        return this.status;
    }

    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public ServiceResourceProperties withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
    }

    public void validate() {
    }
}

