/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.license.validate;

import com.dbeaver.lm.api.LMException;
import com.dbeaver.lm.api.LMLicense;
import com.dbeaver.lm.api.LMLicensePublicService;
import com.dbeaver.lm.api.LMProduct;
import com.dbeaver.lm.api.LMUpdateGroupUsersRequest;
import com.dbeaver.model.license.validate.LicenseRequest;
import com.dbeaver.remote.client.AbstractRemoteClient;
import com.dbeaver.remote.client.BodyConverter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.Base64;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.XMLBuilder;

public class PublicServiceClient
extends AbstractRemoteClient
implements LMLicensePublicService {
    private static final Log log = Log.getLog(PublicServiceClient.class);
    static final String PUBLIC_SERVICE_HOST = "dbeaver.com";
    private static final String PUBLIC_SERVICE_URL = "https://dbeaver.com/lmp/";

    static {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
    }

    public PublicServiceClient(@NotNull String clientId) {
        this(clientId, 0);
    }

    public PublicServiceClient(@NotNull String clientId, int requestTimeout) {
        this(clientId, requestTimeout, 30);
    }

    public PublicServiceClient(@Nullable String clientId, int requestTimeout, int requestRetries) {
        super(PUBLIC_SERVICE_URL, requestTimeout, requestTimeout, List.of(chain -> chain.proceed(PublicServiceClient.buildRequest(clientId, chain.request().newBuilder()))));
    }

    private static Request buildRequest(String clientId, Request.Builder newBuilder) {
        String osName = CommonUtils.notEmpty((String)System.getProperty("os.name")) + " " + CommonUtils.notEmpty((String)System.getProperty("os.arch"));
        if (clientId != null) {
            newBuilder.header("X-Referrer", clientId);
        }
        newBuilder.header("User-Agent", GeneralUtils.getProductTitle() + " [" + osName.trim() + "]");
        return newBuilder.build();
    }

    @NotNull
    public String ping() throws LMException {
        try {
            String url = PublicServiceClient.buildEndpointUrl((String[])new String[]{"ping"});
            return (String)this.executeGetRequest(url, (Type)((Object)String.class));
        }
        catch (Throwable e) {
            throw new LMException("Ping failed", e);
        }
    }

    public String checkCustomerEmail(LMProduct product, String email) throws LMException {
        try {
            String url = PublicServiceClient.buildEndpointUrl((String[])new String[]{"checkCustomer?product=" + product.getId() + "&version=" + product.getVersion() + "&email=" + email});
            return (String)this.executeGetRequest(url, (Type)((Object)String.class));
        }
        catch (Throwable e) {
            throw new LMException("Customer check failed", e);
        }
    }

    public void requestTrialLicense(@NotNull LMProduct product, @NotNull LicenseRequest licenseRequest) throws LMException {
        String body = this.generateLicenseRequest(product, licenseRequest);
        try {
            Request request = new Request.Builder().url(this.buildUrl(PublicServiceClient.buildEndpointUrl((String[])new String[]{"requestTrialLicense"}), Map.of())).post(RequestBody.create((String)body, (MediaType)MediaType.parse((String)"text/xml"))).build();
            Throwable throwable = null;
            Object var6_9 = null;
            try (Response response = this.getHttpClient().newCall(request).execute();){
                if (!response.isSuccessful()) {
                    String message = response.header("ErrorMessage");
                    if (message != null) {
                        throw new LMException(message);
                    }
                    throw new LMException("Bad server status (" + response.code() + "): " + response.message());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (LMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LMException("Error requesting trial license", (Throwable)e);
        }
    }

    @Nullable
    public String checkLicenseStatus(@NotNull LMLicense license, @NotNull LMProduct product) throws LMException {
        try {
            Map<String, String> params = Map.of("product", product.getId(), "version", product.getVersion(), "license", license.getLicenseId(), "crc", license.getDataHash());
            String url = PublicServiceClient.buildEndpointUrl((String[])new String[]{"checkLicense"});
            return (String)this.executeGetRequest(url, params, (Type)((Object)String.class));
        }
        catch (Throwable e) {
            if (e.getCause() instanceof IOException) {
                log.debug((Object)("Error checking license " + license.getLicenseId() + " status: " + e.getMessage()), e);
                return null;
            }
            throw new LMException("License check failed", e);
        }
    }

    @Nullable
    public String getServerTime() throws LMException {
        try {
            String url = PublicServiceClient.buildEndpointUrl((String[])new String[]{"getServerTime"});
            return (String)this.executeGetRequest(url, (Type)((Object)String.class));
        }
        catch (Throwable e) {
            throw new LMException("Getting server time failed", e);
        }
    }

    public String getLicenseUpdate(@NotNull LMLicense license, @NotNull LMProduct product) throws LMException {
        try {
            Map<String, String> params = Map.of("license", license.getLicenseId(), "updateRequest", license.getUpdateRequestHash(), "crc", license.getDataHash());
            String url = PublicServiceClient.buildEndpointUrl((String[])new String[]{"getLicenseUpdate"});
            return (String)this.executeGetRequest(url, params, (Type)((Object)String.class));
        }
        catch (Throwable e) {
            if (e.getCause() instanceof IOException) {
                log.debug((Object)("Error getting license update " + license.getLicenseId() + ": " + e.getCause().getMessage()));
                log.debug((Object)"License is valid but it can't be updated automatically");
                return null;
            }
            throw new LMException("License update read failed", e);
        }
    }

    @NotNull
    public String joinEarlyAccessProgram(@NotNull LMLicense license, @NotNull LMProduct product) throws LMException {
        try {
            return (String)this.executeGetRequestVal(PublicServiceClient.buildEndpointUrl((String[])new String[]{"joinEarlyAccessProgram"}), Map.of("product", product.getId(), "version", product.getVersion(), "license", license.getLicenseId(), "updateRequest", license.getUpdateRequestHash()), (Type)((Object)String.class));
        }
        catch (DBException e) {
            throw new LMException("Unable to join Early Access Program", (Throwable)e);
        }
    }

    @NotNull
    private String generateLicenseRequest(@NotNull LMProduct product, @NotNull LicenseRequest request) throws LMException {
        try {
            StringWriter sw = new StringWriter();
            XMLBuilder xml = new XMLBuilder((Writer)sw, GeneralUtils.UTF8_ENCODING);
            xml.setBeautify(true);
            Throwable throwable = null;
            Object var6_8 = null;
            try (XMLBuilder.Element e1 = xml.startElement("request");){
                xml.addAttribute("license", "trial");
                xml.addAttribute("productId", product.getId());
                xml.addAttribute("productVersion", product.getVersion());
                Throwable throwable2 = null;
                Object var9_13 = null;
                try (XMLBuilder.Element e2 = xml.startElement("customer");){
                    xml.addAttribute("email", request.getEmail());
                    xml.addAttribute("firstName", request.getFirstName());
                    xml.addAttribute("lastName", request.getLastName());
                    xml.addAttribute("company", request.getCompanyName());
                    if (request.isNewslettersInterested()) {
                        xml.addAttribute("subscribe", true);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
            xml.flush();
            return sw.toString();
        }
        catch (IOException e) {
            throw new LMException("IO error generating license request", (Throwable)e);
        }
    }

    protected void handleRequestException(Exception e) throws DBException {
        throw new DBException("LM service remote error", (Throwable)e);
    }

    public boolean isInternalClient() {
        return false;
    }

    public String updateUserList(@NotNull LMLicense license, @NotNull LMUpdateGroupUsersRequest licenseChanges) throws LMException {
        if (CommonUtils.isEmpty((Collection)licenseChanges.getAddedUsers()) && CommonUtils.isEmpty((Collection)licenseChanges.getDeletedUsers()) && CommonUtils.isEmpty((Collection)licenseChanges.getUpdatedUsers())) {
            throw new LMException("No changes in license users");
        }
        try {
            Map<String, String> params = Map.of("product", license.getProductId());
            licenseChanges.setLicenseText(Base64.encode((byte[])license.getEncoded()));
            String url = PublicServiceClient.buildEndpointUrl((String[])new String[]{"updateUserList"});
            Request request = this.buildPostRequest(url, params, licenseChanges, BodyConverter.JSON);
            return (String)this.executeRequest(request, (Type)((Object)String.class));
        }
        catch (Throwable e) {
            throw new LMException("License check failed", e);
        }
    }
}

