/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.license.validate;

import com.dbeaver.lm.api.LMException;
import com.dbeaver.lm.api.LMLicense;
import com.dbeaver.lm.api.LMLicenseManager;
import com.dbeaver.lm.api.LMLicenseStatus;
import com.dbeaver.lm.api.LMLicenseValidator;
import com.dbeaver.lm.api.LMProduct;
import com.dbeaver.lm.api.LMReleaseInfo;
import com.dbeaver.lm.api.LMStatusDetails;
import com.dbeaver.lm.api.LMSubscription;
import com.dbeaver.lm.api.LMUtils;
import com.dbeaver.lm.api.LMValidateException;
import com.dbeaver.model.license.validate.LMPublicAPI;
import com.dbeaver.model.license.validate.LicenseCheckResult;
import java.util.HashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;

public class PublicLicenseValidator
implements LMLicenseValidator {
    public static final LMLicenseValidator PUBLIC_LICENSE_VALIDATOR = new PublicLicenseValidator();
    private static final Log log = Log.getLog(LMPublicAPI.class);
    private final Map<String, LicenseCheckResult> validateCache = new HashMap<String, LicenseCheckResult>();

    public void validateLicense(@NotNull LMLicenseManager licenseManager, @NotNull String clientId, @NotNull LMProduct product, @NotNull LMLicense license) throws LMValidateException {
        LicenseCheckResult result = this.validateCache.get(PublicLicenseValidator.getLicenseKey(license));
        if (result == null || license.isSubscription() && result.getSubscription() == null) {
            try {
                result = LMPublicAPI.checkLicenseStatus(clientId, licenseManager, license, product);
            }
            finally {
                if (result != null) {
                    this.validateCache.put(PublicLicenseValidator.getLicenseKey(license), result);
                }
            }
        }
        if (result.getLicenseStatus() != LMLicenseStatus.VALID) {
            throw new LMValidateException(license, result.getLicenseStatus(), result.getCheckStatus().getMessage(), result.getCheckStatus().getException());
        }
        if (license.isSubscription()) {
            LMSubscription subscriptionInfo = result.getSubscription();
            if (subscriptionInfo == null) {
                subscriptionInfo = licenseManager.getSubscriptionInfo(license);
            } else {
                try {
                    licenseManager.updateSubscription(product, subscriptionInfo);
                }
                catch (LMException e) {
                    log.error((Object)"Can't update subscription information in the local database", (Throwable)e);
                }
            }
            String noInternetWarning = "Note: you need internet access to use subscription licenses.\nCheck your internet connection and/or firewall settings and restart application.";
            if (subscriptionInfo == null) {
                LMStatusDetails remoteStatus = new LMStatusDetails("Invalid subscription", "Can't find subscription information for license '" + license.getLicenseId() + "'.\n" + noInternetWarning, false);
                license.setRemoteStatus(remoteStatus);
                throw new LMValidateException(license, LMLicenseStatus.INVALID, remoteStatus.getMessage());
            }
            if (subscriptionInfo.isExpired()) {
                LMStatusDetails remoteStatus = new LMStatusDetails("Expired", "License '" + license.getLicenseId() + "' subscription has been expired (" + LMUtils.HR_DATE_FORMAT.format(subscriptionInfo.getExpirationDate()) + ").\n" + noInternetWarning, false);
                license.setRemoteStatus(remoteStatus);
                throw new LMValidateException(license, LMLicenseStatus.EXPIRED, remoteStatus.getMessage());
            }
        }
    }

    public void clearLicenseCache(@NotNull String licenseId) {
        this.validateCache.keySet().removeIf(key -> key.startsWith(licenseId + ":"));
    }

    public void clearLicenseCache() {
        this.validateCache.clear();
    }

    @Nullable
    public String getLicenseValidationStatus(LMLicense license) {
        LicenseCheckResult checkResult = this.validateCache.get(PublicLicenseValidator.getLicenseKey(license));
        return checkResult == null || checkResult.getLicenseStatus() == LMLicenseStatus.VALID ? null : checkResult.getCheckStatus().getMessage();
    }

    @Nullable
    public LMReleaseInfo getValidationReleaseInfo(@NotNull LMLicense license) {
        return this.validateCache.get(PublicLicenseValidator.getLicenseKey(license)).getReleaseInfo();
    }

    private static String getLicenseKey(LMLicense license) {
        return license.getLicenseId() + ":" + license.getDataHash();
    }
}

