/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.license.embedded;

import com.dbeaver.lm.api.LMEncryption;
import com.dbeaver.lm.api.LMKeyProvider;
import com.dbeaver.lm.api.LMProduct;
import com.dbeaver.lm.api.LMUtils;
import java.io.InputStream;
import java.net.URL;
import java.security.Key;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.impl.app.ApplicationRegistry;

class LicenseKeyProviderEmbedded
implements LMKeyProvider {
    private static final Log log = Log.getLog(LicenseKeyProviderEmbedded.class);

    LicenseKeyProviderEmbedded() {
    }

    public Key getEncryptionKey(LMProduct product) {
        return null;
    }

    public Key getDecryptionKey(LMProduct product) {
        String id = product.getId();
        String resourceName = "keys/" + id + "-public.key";
        URL keyURL = ApplicationRegistry.getInstance().getApplication().getContributorBundle().getResource(resourceName);
        if (keyURL != null) {
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (InputStream keyStream = keyURL.openStream();){
                    byte[] keyData = LMUtils.readEncryptedString((InputStream)keyStream);
                    return LMEncryption.generatePublicKey((byte[])keyData);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.error((Object)e);
                return null;
            }
        }
        log.error((Object)("Public key file not found for product " + id));
        return null;
    }
}

