/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.license.cli;

import com.dbeaver.lm.api.LMException;
import com.dbeaver.lm.api.LMLicense;
import com.dbeaver.model.license.DBPLicenseService;
import com.dbeaver.model.license.app.DBPApplicationLicensed;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.cli.CLIException;
import org.jkiss.dbeaver.model.cli.CLIUtils;
import org.jkiss.dbeaver.model.cli.model.CommandLineWithAuth;
import org.jkiss.dbeaver.model.cli.model.option.InputFileOption;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;
import picocli.CommandLine;

@CommandLine.Command(name="import-license", description={"Imports product license"})
public class ImportLicenseParameterHandler
extends CommandLineWithAuth {
    public static final String COMMAND_NAME = "import-license";
    @CommandLine.Option(names={"-license-text"}, description={"License text"})
    private String licenseText;
    @CommandLine.Mixin
    private InputFileOption inputFileOption;

    /*
     * WARNING - void declaration
     */
    public void run() {
        void applicationLicensed;
        super.run();
        String text = this.licenseText;
        if (CommonUtils.isEmpty((String)text)) {
            text = CLIUtils.readValueFromFileOrSystemIn((InputFileOption)this.inputFileOption);
        }
        if (CommonUtils.isEmpty((String)text)) {
            throw new CLIException("License text is empty", 2);
        }
        DBPApplication dBPApplication = DBWorkbench.getPlatform().getApplication();
        if (!(dBPApplication instanceof DBPApplicationLicensed)) {
            throw new CLIException("Application is not licensed", 1);
        }
        DBPApplicationLicensed dBPApplicationLicensed = (DBPApplicationLicensed)dBPApplication;
        DBPLicenseService licenseService = applicationLicensed.getLicenseService();
        try {
            LMLicense license = licenseService.importProductLicense(text);
            applicationLicensed.invalidateLicense();
            this.context().addResult("License imported successfully: " + license.getLicenseId());
        }
        catch (LMException e) {
            throw new CLIException("Error importing license: " + e.getMessage(), (Throwable)e, 1);
        }
    }
}

