/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.security.truststore.keystore;

import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.utils.CommonUtils;

public class KeyStoreDescriptor
extends AbstractDescriptor {
    @NotNull
    private final String id;
    @Nullable
    private final String storeType;
    @NotNull
    private final String label;
    @NotNull
    private final String description;
    @NotNull
    private final String filePath;
    @NotNull
    private final Set<String> supportedOs;
    private final boolean modifiable;

    public KeyStoreDescriptor(@NotNull IConfigurationElement cfg) {
        super(cfg);
        this.id = cfg.getAttribute("id");
        this.storeType = CommonUtils.nullIfEmpty((String)cfg.getAttribute("storeType"));
        this.label = cfg.getAttribute("label");
        this.description = cfg.getAttribute("description");
        this.supportedOs = Set.of(cfg.getAttribute("os").split(","));
        this.filePath = cfg.getAttribute("filePath");
        this.modifiable = Boolean.parseBoolean(cfg.getAttribute("modifiable"));
    }

    @NotNull
    public String getFilePath() {
        return this.filePath;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    public boolean isModifiable() {
        return this.modifiable;
    }

    @Nullable
    public String getStoreType() {
        return this.storeType;
    }

    @NotNull
    public String getLabel() {
        return this.label;
    }

    public boolean isMacOs() {
        return this.supportedOs.contains("macosx");
    }

    public boolean isUnix() {
        return this.supportedOs.contains("linux");
    }

    public boolean isWindows() {
        return this.supportedOs.contains("win32");
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }
}

