/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.net.k8s;

import com.dbeaver.model.net.k8s.KubeCtrlExecutor;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class K8SContextInfo {
    private final List<String> contexts;

    public List<String> getContexts() {
        return this.contexts;
    }

    private K8SContextInfo(List<String> contexts) {
        this.contexts = contexts;
    }

    public static K8SContextInfo getContextInfo(@NotNull DBRProgressMonitor monitor, @NotNull DBWHandlerConfiguration configuration) throws DBException {
        String ctxOut = KubeCtrlExecutor.executeCommand(monitor, configuration, true, "config", "get-contexts");
        return new K8SContextInfo(K8SContextInfo.parseContexts(ctxOut));
    }

    public static K8SContextInfo getContextInfo(@NotNull String kubectlOutput) {
        return new K8SContextInfo(K8SContextInfo.parseContexts(kubectlOutput));
    }

    private static List<String> parseContexts(String rawContexts) {
        return rawContexts.lines().skip(1L).map(CommonUtils.WHITESPACE_PATTERN::split).filter(array -> ((String[])array).length > 1).map(array -> array[1]).toList();
    }
}

