/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.util;

import java.io.IOException;
import java.io.InputStream;
import liquibase.Scope;
import liquibase.resource.PathHandlerFactory;
import liquibase.resource.Resource;
import liquibase.util.FileUtil;

public class ResourceUtil {
    public static Resource getResource(String path) throws IOException {
        Resource resource;
        PathHandlerFactory factory = (PathHandlerFactory)Scope.getCurrentScope().getSingleton(PathHandlerFactory.class);
        if (ResourceUtil.isAbsolute(path) && (resource = factory.getResource(path)).exists()) {
            return resource;
        }
        return Scope.getCurrentScope().getResourceAccessor().get(path);
    }

    public static boolean isAbsolute(String path) throws IOException {
        if (path.matches("^\\w\\w+:.*")) {
            return true;
        }
        return FileUtil.isAbsolute((String)path);
    }

    public static InputStream getResourceInputStream(String path) throws IOException {
        Resource resource = ResourceUtil.getResource(path);
        return ResourceUtil.getResourceInputStream(resource);
    }

    public static InputStream getResourceInputStream(Resource resource) throws IOException {
        if (resource.exists()) {
            return resource.openInputStream();
        }
        return null;
    }
}

