/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.trigger.change;

import com.datical.liquibase.ext.storedlogic.trigger.Trigger;
import com.datical.liquibase.ext.storedlogic.trigger.change.EnableTriggerStatement;
import liquibase.database.Database;
import liquibase.database.core.CockroachDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;

public class EnableTriggerGenerator
extends AbstractSqlGenerator<EnableTriggerStatement> {
    public boolean supports(EnableTriggerStatement enableTriggertStatement, Database database) {
        return database instanceof OracleDatabase || database instanceof MSSQLDatabase || database instanceof PostgresDatabase && !(database instanceof CockroachDatabase);
    }

    public ValidationErrors validate(EnableTriggerStatement enableTriggerStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkDisallowedField("catalogName", (Object)enableTriggerStatement.getCatalogName(), database, new Class[]{MSSQLDatabase.class});
        validationErrors.checkRequiredField("triggerName", (Object)enableTriggerStatement.getTriggerName());
        if (database instanceof MSSQLDatabase) {
            if (enableTriggerStatement.getScope() != null && !enableTriggerStatement.getScope().equalsIgnoreCase("CATALOG") && !enableTriggerStatement.getScope().equalsIgnoreCase("TABLE")) {
                validationErrors.addError("Invalid enableTrigger scope: " + enableTriggerStatement.getScope());
                if (enableTriggerStatement.getTableName() != null && enableTriggerStatement.getScope().equalsIgnoreCase("CATALOG")) {
                    validationErrors.addError("Cannot specify tableName and scope != TABLE");
                }
            }
            if ((enableTriggerStatement.getScope() == null || enableTriggerStatement.getScope().equals("TABLE")) && enableTriggerStatement.getTableName() == null) {
                validationErrors.checkRequiredField("tableName", (Object)enableTriggerStatement.getTableName());
            }
        }
        if (database instanceof PostgresDatabase) {
            validationErrors.checkRequiredField("tableName", (Object)enableTriggerStatement.getTableName());
        }
        return validationErrors;
    }

    public Sql[] generateSql(EnableTriggerStatement enableTriggerStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        StringBuilder sql = new StringBuilder();
        if (database instanceof OracleDatabase) {
            sql.append("ALTER TRIGGER ");
            if (enableTriggerStatement.getTriggerName() == null) {
                throw new IllegalStateException("Sorry but triggerName must be set");
            }
            sql.append(database.escapeObjectName(null, enableTriggerStatement.getSchemaName(), enableTriggerStatement.getTriggerName(), Trigger.class)).append(" ");
            sql.append("ENABLE");
        } else if (database instanceof PostgresDatabase) {
            sql.append("ALTER TABLE ");
            sql.append(database.escapeObjectName(null, enableTriggerStatement.getSchemaName(), enableTriggerStatement.getTableName(), Trigger.class)).append(" ");
            sql.append(" ENABLE TRIGGER ");
            sql.append(database.escapeObjectName(enableTriggerStatement.getTriggerName(), Trigger.class));
        } else {
            sql.append("ENABLE TRIGGER ");
            if (enableTriggerStatement.getTriggerName() == null) {
                throw new IllegalStateException("Sorry but triggerName must be set");
            }
            sql.append(database.escapeObjectName(null, enableTriggerStatement.getSchemaName(), enableTriggerStatement.getTriggerName(), Trigger.class)).append(" ");
            sql.append(" ON ");
            if (enableTriggerStatement.getScope() != null && enableTriggerStatement.getScope().equalsIgnoreCase("CATALOG")) {
                sql.append("DATABASE");
            } else {
                sql.append(database.escapeTableName(enableTriggerStatement.getCatalogName(), enableTriggerStatement.getSchemaName(), enableTriggerStatement.getTableName()));
            }
        }
        UnparsedSql generatedSql = new UnparsedSql(sql.toString(), new DatabaseObject[0]);
        return new Sql[]{generatedSql};
    }
}

