/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.config;

import com.datical.liquibase.ext.util.ProStringUtil;
import liquibase.configuration.AutoloadedConfigurations;
import liquibase.configuration.ConfigurationDefinition;
import liquibase.util.StringUtil;

public class ExtendedLiquibaseCommandLineConfiguration
implements AutoloadedConfigurations {
    public static final ConfigurationDefinition<String> CUSTOM_LOG_DATA_FILE;
    public static final ConfigurationDefinition<CustomLogDataFrequency> CUSTOM_LOG_DATA_FREQUENCY;
    public static final ConfigurationDefinition<Boolean> PRO_STRICT;
    public static final ConfigurationDefinition<Boolean> MIRROR_OUTPUT_TO_CONSOLE;

    static {
        ConfigurationDefinition.Builder builder = new ConfigurationDefinition.Builder("liquibase");
        CUSTOM_LOG_DATA_FILE = builder.define("customLogDataFile", String.class).setDescription(ProStringUtil.markWithPro("Relative or fully qualified path to a yaml file containing key:value data to inject or exclude data from JSON structured logs. Learn more at https://docs.liquibase.com/structured-logging")).build();
        CUSTOM_LOG_DATA_FREQUENCY = builder.define("customLogDataFrequency", CustomLogDataFrequency.class).setDescription(ProStringUtil.markWithPro("The frequency that the custom log data will be entered into the logs. Available options are: " + StringUtil.join((Object[])CustomLogDataFrequency.values(), (String)",", Object::toString))).setDefaultValue((Object)CustomLogDataFrequency.REPEATED).build();
        MIRROR_OUTPUT_TO_CONSOLE = builder.define("mirrorOutputToConsole", Boolean.class).setDescription(ProStringUtil.markWithPro("When set to true, console output will be mirrored to both the specified output-file and the console. If output-file is not set, the 'mirror-output-to-console' argument has no effect.")).setDefaultValue((Object)false).build();
        PRO_STRICT = builder.define("proStrict", Boolean.class).setDescription(ProStringUtil.markWithPro("If true, the Liquibase operations will fail when specified paths to Pro resource files (flow files, checks settings files, native executor conf files, etc) or rollback scripts are missing or empty.")).setDefaultValue((Object)false).build();
    }

    public static enum CustomLogDataFrequency {
        ONCE,
        REPEATED;

    }
}

