/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.helpers;

import com.datical.liquibase.ext.arguments.DriftDetectionArguments;
import com.datical.liquibase.ext.util.ProStringUtil;
import java.util.Collections;
import java.util.List;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;

public class DriftDetectCommandArguments
extends AbstractCommandStep {
    protected static final String[] COMMAND_NAME = new String[]{"driftDetectArguments"};
    public static final String INVALID_SEVERITY_ERROR_TEMPLATE = "ERROR: The command arguments '--drift-severity', '--drift-severity-unexpected', '--drift-severity-missing', '--drift-severity-changed' set the return code when drift is detected. These can be set on the CLI, environment variables, defaults file, etc, and the value options are 0, 1, 2 ,3, or 4. The value '%s' is not valid.";
    public static final CommandArgumentDefinition<Integer> DRIFT_SEVERITY;
    public static final CommandArgumentDefinition<Integer> DRIFT_SEVERITY_MISSING;
    public static final CommandArgumentDefinition<Integer> DRIFT_SEVERITY_UNEXPECTED;
    public static final CommandArgumentDefinition<Integer> DRIFT_SEVERITY_CHANGED;

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public List<Class<?>> providedDependencies() {
        return Collections.singletonList(DriftDetectionArguments.class);
    }

    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        CommandScope commandScope = resultsBuilder.getCommandScope();
        int defaultSeverity = DriftDetectCommandArguments.handleNullSeverity((Integer)commandScope.getArgumentValue(DRIFT_SEVERITY));
        int missingSeverity = DriftDetectCommandArguments.handleNullSeverity((Integer)commandScope.getArgumentValue(DRIFT_SEVERITY_MISSING));
        int unexpectedSeverity = DriftDetectCommandArguments.handleNullSeverity((Integer)commandScope.getArgumentValue(DRIFT_SEVERITY_UNEXPECTED));
        int changedSeverity = DriftDetectCommandArguments.handleNullSeverity((Integer)commandScope.getArgumentValue(DRIFT_SEVERITY_CHANGED));
        DriftDetectionArguments arguments = new DriftDetectionArguments(defaultSeverity, missingSeverity, unexpectedSeverity, changedSeverity);
        commandScope.provideDependency(DriftDetectionArguments.class, (Object)arguments);
    }

    private static Integer determineSeverity(Object severity) {
        if (severity == null) {
            return 0;
        }
        if (severity instanceof String) {
            String severityString = (String)severity;
            try {
                int severityValue = Integer.parseInt(severityString);
                if (severityValue < 0 || severityValue > 4) {
                    throw new IllegalArgumentException(String.format(INVALID_SEVERITY_ERROR_TEMPLATE, severityString));
                }
                return severityValue;
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException(String.format(INVALID_SEVERITY_ERROR_TEMPLATE, severityString));
            }
        }
        if (severity instanceof Integer) {
            int severityValue = (Integer)severity;
            if (severityValue < 0 || severityValue > 4) {
                throw new IllegalArgumentException(String.format(INVALID_SEVERITY_ERROR_TEMPLATE, severityValue));
            }
            return severityValue;
        }
        return null;
    }

    private static int handleNullSeverity(Integer provided) {
        if (provided == null) {
            return 0;
        }
        return provided;
    }

    public boolean isInternal() {
        return true;
    }

    static {
        CommandBuilder builder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        DRIFT_SEVERITY = builder.argument("driftSeverity", Integer.class).description(ProStringUtil.markWithPro("Sets the return code for all drift types found in diff or diffchangelog operations. Options are 0, 1, 2, 3, 4")).setValueHandler(DriftDetectCommandArguments::determineSeverity).defaultValue((Object)0).build();
        DRIFT_SEVERITY_MISSING = builder.argument("driftSeverityMissing", Integer.class).description(ProStringUtil.markWithPro("Sets the return code for \"missing\" type drift found in diff or diffchangelog operations. Options are 0, 1, 2, 3, 4")).setValueHandler(DriftDetectCommandArguments::determineSeverity).defaultValue((Object)0).build();
        DRIFT_SEVERITY_UNEXPECTED = builder.argument("driftSeverityUnexpected", Integer.class).description(ProStringUtil.markWithPro("Sets the return code for \"unexpected\" type drift found in diff or diffchangelog operations. Options are 0, 1, 2, 3, 4")).setValueHandler(DriftDetectCommandArguments::determineSeverity).defaultValue((Object)0).build();
        DRIFT_SEVERITY_CHANGED = builder.argument("driftSeverityChanged", Integer.class).description(ProStringUtil.markWithPro("Sets the return code for \"changed\" type drift found in diff or diffchangelog operations. Options are 0, 1, 2, 3, 4")).setValueHandler(DriftDetectCommandArguments::determineSeverity).defaultValue((Object)0).build();
    }
}

