/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.appdba.diff.compare;

import com.datical.liquibase.ext.appdba.synonym.Synonym;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import liquibase.database.Database;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.compare.DatabaseObjectComparator;
import liquibase.diff.compare.DatabaseObjectComparatorChain;
import liquibase.diff.compare.DatabaseObjectComparatorFactory;
import liquibase.diff.compare.core.DefaultDatabaseObjectComparator;
import liquibase.structure.DatabaseObject;

public class SynonymComparator
implements DatabaseObjectComparator {
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (Synonym.class.isAssignableFrom(objectType)) {
            return 5;
        }
        return -1;
    }

    public String[] hash(DatabaseObject databaseObject, Database accordingTo, DatabaseObjectComparatorChain chain) {
        ArrayList<String> hashes = new ArrayList<String>();
        hashes.addAll(Arrays.asList(chain.hash(databaseObject, accordingTo)));
        String type = ((Synonym)databaseObject).isPrivate() ? "private" : "public";
        hashes.add(type);
        return hashes.toArray(new String[hashes.size()]);
    }

    public boolean isSameObject(DatabaseObject databaseObject1, DatabaseObject databaseObject2, Database accordingTo, DatabaseObjectComparatorChain chain) {
        if (!(databaseObject1 instanceof Synonym) || !(databaseObject2 instanceof Synonym)) {
            return false;
        }
        if (((Synonym)databaseObject1).isPrivate() != ((Synonym)databaseObject2).isPrivate()) {
            return false;
        }
        if (!DefaultDatabaseObjectComparator.nameMatches((DatabaseObject)databaseObject1, (DatabaseObject)databaseObject2, (Database)accordingTo)) {
            return false;
        }
        return DatabaseObjectComparatorFactory.getInstance().isSameObject((DatabaseObject)databaseObject1.getSchema(), (DatabaseObject)databaseObject2.getSchema(), chain.getSchemaComparisons(), accordingTo);
    }

    public ObjectDifferences findDifferences(DatabaseObject databaseObject1, DatabaseObject databaseObject2, Database accordingTo, CompareControl compareControl, DatabaseObjectComparatorChain chain, Set<String> exclude) {
        exclude.add("objectSchema");
        exclude.add("_actualObjectCatalogName");
        return chain.findDifferences(databaseObject1, databaseObject2, accordingTo, compareControl, exclude);
    }
}

