/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.team.ui.admin;

import com.dbeaver.lm.api.LMRole;
import com.dbeaver.team.model.TeamManager;
import com.dbeaver.team.ui.admin.CreateUserDialog;
import com.dbeaver.team.ui.admin.SelectSubjectDialog;
import com.dbeaver.team.ui.admin.SubjectsFolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbenchPart;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPPage;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.dbeaver.model.security.SMSubjectType;
import org.jkiss.dbeaver.model.security.user.SMSubject;
import org.jkiss.dbeaver.model.security.user.SMTeam;
import org.jkiss.dbeaver.model.security.user.SMUser;
import org.jkiss.dbeaver.model.security.user.SMUserFilter;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ListContentProvider;
import org.jkiss.dbeaver.ui.dialogs.connection.PasswordChangeDialog;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.SecurityUtils;

class UsersFolder
extends SubjectsFolder<SMUser> {
    public static final String LOCAL_AUTH_PROVIDER_ID = "local";
    private Text usernameText;
    private Combo roleText;
    private Button activeCheck;
    private Text userAuthProviders;
    private TableViewer teamsViewer;
    private boolean showInactive = false;
    private SMUser currentUser;
    private Button changePasswordButton;
    private ToolItem addTeamItem;
    private Action disableAction;

    public UsersFolder(IWorkbenchPart part) {
        super(part);
    }

    @Override
    @NotNull
    protected SMSubjectType getSubjectType() {
        return SMSubjectType.user;
    }

    @Override
    protected SMSubject getCurrentSubject() {
        return this.currentUser;
    }

    @Override
    protected Collection<SMUser> loadObjects(DBRProgressMonitor monitor) throws DBException {
        ArrayList<SMUser> users = new ArrayList<SMUser>(TeamManager.getInstance().getUsers(new SMUserFilter(new DBPPage(0, 1000))));
        users.sort((o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
        return users;
    }

    @Override
    protected DBPImage getObjectImage(SMUser item) {
        return DBIcon.TREE_USER;
    }

    @Override
    protected boolean isObjectMatches(SMUser element, String searchString) {
        return element.getName().toUpperCase().contains(searchString.toUpperCase());
    }

    @Override
    protected void contributeToToolbar(IContributionManager contributionManager) {
        Action showActiveAction = new Action("Show Inactive", 2){
            {
                this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SHOW_ALL_DETAILS));
                this.setToolTipText("Show deactivated users");
                this.setChecked(UsersFolder.this.showInactive);
            }

            public void run() {
                UsersFolder.this.showInactive = !UsersFolder.this.showInactive;
                UsersFolder.this.getObjectList().getItemsViewer().refresh();
            }
        };
        contributionManager.add((IContributionItem)ActionUtils.makeActionContribution((IAction)showActiveAction, (boolean)true));
        contributionManager.add((IContributionItem)ActionUtils.makeActionContribution((IAction)new Action("Create"){
            {
                this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ADD));
                this.setToolTipText("Create new user");
            }

            public void run() {
                UsersFolder.this.createNewUser();
            }
        }, (boolean)true));
        Action deleteAction = new Action("Delete"){
            {
                this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.DELETE));
                this.setToolTipText("Delete users");
            }

            public void run() {
                UsersFolder.this.deleteSelectedUsers();
            }
        };
        this.disableAction = new Action("Disable"){
            {
                this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.CHECK_ON));
                this.setToolTipText("Disable Users");
            }

            public void run() {
                UsersFolder.this.disableSelectedUsers();
            }
        };
        deleteAction.setEnabled(false);
        this.disableAction.setEnabled(false);
        contributionManager.add((IContributionItem)ActionUtils.makeActionContribution((IAction)deleteAction, (boolean)true));
        contributionManager.add((IContributionItem)ActionUtils.makeActionContribution((IAction)this.disableAction, (boolean)true));
        this.getObjectList().getItemsViewer().addSelectionChangedListener(event -> {
            boolean canDisable;
            deleteAction.setEnabled(!event.getStructuredSelection().isEmpty());
            boolean bl = canDisable = !event.getStructuredSelection().isEmpty();
            if (canDisable) {
                List list = this.getObjectList().getItemsViewer().getStructuredSelection().toList();
                canDisable = list.stream().anyMatch(SMUser::isEnabled);
            }
            this.disableAction.setEnabled(canDisable);
        });
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getObjectList().getItemsViewer().addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return ((SMUser)element).isEnabled() || UsersFolder.this.showInactive;
            }
        });
    }

    @Override
    public void createDetailsPanel(Composite parent) {
        Composite main = UIUtils.createComposite((Composite)parent, (int)2);
        ((GridLayout)main.getLayout()).makeColumnsEqualWidth = true;
        main.setLayoutData((Object)new GridData(1808));
        Group infoPanel = UIUtils.createControlGroup((Composite)main, (String)"Information", (int)2, (int)768, (int)-1);
        infoPanel.setLayoutData((Object)new GridData(770));
        this.usernameText = UIUtils.createLabelText((Composite)infoPanel, (String)"Username", null, (int)2056);
        this.roleText = UIUtils.createLabelCombo((Composite)infoPanel, (String)"Role", (String)"User role", (int)2060);
        LMRole[] lMRoleArray = LMRole.values();
        int n = lMRoleArray.length;
        int n2 = 0;
        while (n2 < n) {
            LMRole lmRole = lMRoleArray[n2];
            this.roleText.add(lmRole.name());
            ++n2;
        }
        this.roleText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UsersFolder.this.changeUserRole();
            }
        });
        this.activeCheck = UIUtils.createCheckbox((Composite)infoPanel, (String)"Active", (String)"User is active", (boolean)false, (int)1);
        this.activeCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UsersFolder.this.changeUserActive();
                UsersFolder.this.disableAction.setEnabled(UsersFolder.this.activeCheck.getSelection());
            }
        });
        this.changePasswordButton = UIUtils.createDialogButton((Composite)infoPanel, (String)"Change password", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UsersFolder.this.changeUserPassword();
            }
        });
        this.changePasswordButton.setLayoutData((Object)new GridData(128));
        this.userAuthProviders = UIUtils.createLabelText((Composite)infoPanel, (String)"Authentication", null, (int)2056);
        this.createMetaParams(main);
        Group teamsPanel = UIUtils.createControlGroup((Composite)main, (String)"Teams", (int)1, (int)768, (int)-1);
        teamsPanel.setLayoutData((Object)new GridData(1808));
        this.teamsViewer = new TableViewer((Composite)teamsPanel, 4);
        this.teamsViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.teamsViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.teamsViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                return DBeaverIcons.getImage((DBPImage)DBIcon.TREE_USER_GROUP);
            }
        });
        ToolBar teamToolbar = new ToolBar((Composite)teamsPanel, 131328);
        this.addTeamItem = UIUtils.createToolItem((ToolBar)teamToolbar, (String)"Add", (String)"Add", (DBPImage)UIIcon.ADD, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UsersFolder.this.addTeamAccess();
            }
        });
        ToolItem removeTeamItem = UIUtils.createToolItem((ToolBar)teamToolbar, (String)"Remove", (String)"Remove", (DBPImage)UIIcon.DELETE, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UsersFolder.this.removeTeamAccess(UsersFolder.this.teamsViewer.getStructuredSelection().toList());
            }
        });
        removeTeamItem.setEnabled(false);
        this.teamsViewer.addSelectionChangedListener(event -> removeTeamItem.setEnabled(!event.getSelection().isEmpty()));
        this.createProjectsPanel(main);
    }

    @Override
    public void fillDetailsPanel(@Nullable SMUser object) {
        this.currentUser = object;
        this.usernameText.setText(object != null ? object.getUserId() : "");
        this.roleText.setText(object != null ? CommonUtils.notEmpty((String)object.getAuthRole()) : "");
        this.activeCheck.setSelection(object != null && object.isEnabled());
        this.activeCheck.setEnabled(object != null);
        if (object != null) {
            try {
                List<String> linkedProviders = TeamManager.getInstance().getUserLinkedProviders(this.currentUser.getUserId());
                this.userAuthProviders.setText(String.join((CharSequence)",", linkedProviders));
                this.changePasswordButton.setEnabled(linkedProviders.contains(LOCAL_AUTH_PROVIDER_ID));
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError("Error reading authentication info", null, (Throwable)e);
            }
        } else {
            this.userAuthProviders.setText("");
            this.changePasswordButton.setEnabled(false);
        }
        this.loadMetaParams((SMSubject)object);
        this.teamsViewer.setInput(Collections.emptyList());
        this.addTeamItem.setEnabled(object != null);
        if (object != null) {
            SMTeam[] userTeams = new SMTeam[]{};
            try {
                userTeams = TeamManager.getInstance().getAdminController().getUserTeams(this.currentUser.getUserId());
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError("Error reading user teams", null, (Throwable)e);
            }
            this.teamsViewer.setInput(Arrays.asList(userTeams));
        }
        this.loadProjectsDetails((SMSubject)object);
    }

    private void changeUserPassword() {
        PasswordChangeDialog dialog = new PasswordChangeDialog(this.getObjectList().getShell(), "Set new password", this.currentUser.getName(), null, false, false);
        if (dialog.open() == 0) {
            LinkedHashMap<String, String> credentials = new LinkedHashMap<String, String>();
            credentials.put("user", this.currentUser.getUserId());
            credentials.put("password", SecurityUtils.makeDigest((String)dialog.getPasswordInfo().getNewPassword()));
            try {
                TeamManager.getInstance().getAdminController().setUserCredentials(this.currentUser.getUserId(), LOCAL_AUTH_PROVIDER_ID, credentials);
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError("Error changing user credentials", null, (Throwable)e);
            }
        }
    }

    private void addTeamAccess() {
        SelectSubjectDialog dialog = new SelectSubjectDialog(this.getObjectList().getShell(), SelectSubjectDialog.SubjectType.TEAM);
        List<String> curTeamIds = ((List)this.teamsViewer.getInput()).stream().map(SMTeam::getTeamId).collect(Collectors.toList());
        dialog.setExcludeSubjects(curTeamIds);
        if (dialog.open() == 0) {
            List<SMSubject> selectedTeams = dialog.getSelectedSubjects();
            HashSet<String> newTeamList = new HashSet<String>(curTeamIds);
            newTeamList.addAll(selectedTeams.stream().map(SMSubject::getSubjectId).collect(Collectors.toSet()));
            try {
                String[] teamIds = newTeamList.toArray(new String[0]);
                TeamManager.getInstance().getAdminController().setUserTeams(this.currentUser.getUserId(), teamIds, TeamManager.getInstance().getCurrentUserId());
                this.currentUser.setUserTeams(teamIds);
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError("Error changing user teams", null, (Throwable)e);
                return;
            }
            this.fillDetailsPanel(this.currentUser);
        }
    }

    private void removeTeamAccess(List<SMTeam> teams) {
        List teamIds = teams.stream().map(SMTeam::getTeamId).collect(Collectors.toList());
        if (!UIUtils.confirmAction((Shell)this.getObjectList().getShell(), (String)"Remove from team", (String)("Are you sure you want to remove user '" + this.currentUser.getUserId() + "' from team '" + String.join((CharSequence)" ", teamIds) + "'?"))) {
            return;
        }
        String[] newUserTeams = (String[])Arrays.stream(this.currentUser.getUserTeams()).filter(t -> !teamIds.contains(t)).toArray(String[]::new);
        try {
            TeamManager.getInstance().getAdminController().setUserTeams(this.currentUser.getUserId(), newUserTeams, TeamManager.getInstance().getCurrentUserId());
            this.currentUser.setUserTeams(newUserTeams);
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Error changing user teams", null, (Throwable)e);
            return;
        }
        this.fillDetailsPanel(this.currentUser);
    }

    private void createNewUser() {
        CreateUserDialog dialog = new CreateUserDialog(this.getObjectList().getShell());
        if (dialog.open() == 0) {
            this.currentUser = dialog.getNewUser();
            this.getObjectList().appendListData(Collections.singletonList(this.currentUser));
            this.getObjectList().getItemsViewer().setSelection((ISelection)new StructuredSelection((Object)this.currentUser));
            this.fillDetailsPanel(this.currentUser);
        }
    }

    private void disableSelectedUsers() {
        List selectedUsers = this.getObjectList().getItemsViewer().getStructuredSelection().toList();
        if (selectedUsers.isEmpty()) {
            return;
        }
        String userIDs = selectedUsers.stream().map(SMUser::getUserId).collect(Collectors.joining(", "));
        if (!UIUtils.confirmAction((Shell)this.getObjectList().getShell(), (String)"Disable user(s)", (String)("Are you sure you want to disable user(s) '" + userIDs + "'?"))) {
            return;
        }
        for (SMUser user : selectedUsers) {
            try {
                TeamManager.getInstance().getAdminController().enableUser(user.getUserId(), false, TeamManager.getInstance().getCurrentUserId(), "Disabled manually");
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError("Error disabling user " + user.getUserId(), null, (Throwable)e);
            }
        }
        if (!this.showInactive) {
            this.currentUser = null;
            this.fillDetailsPanel((SMUser)null);
        }
        this.activeCheck.setSelection(false);
        this.getObjectList().getItemsViewer().refresh((Object)this.currentUser);
        this.getObjectList().loadData();
    }

    private void deleteSelectedUsers() {
        List selectedUsers = this.getObjectList().getItemsViewer().getStructuredSelection().toList();
        if (selectedUsers.isEmpty()) {
            return;
        }
        String userIDs = selectedUsers.stream().map(SMUser::getUserId).collect(Collectors.joining(", "));
        if (!UIUtils.confirmAction((Shell)this.getObjectList().getShell(), (String)"Delete user(s)", (String)("Are you sure you want to delete user(s) '" + userIDs + "'?\nThis will remove them from all existing groups and delete user project contents"))) {
            return;
        }
        DBSSecretController secretController = null;
        try {
            secretController = DBSSecretController.getGlobalSecretController();
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError("Error getting secret controller", null, (Throwable)e);
        }
        for (SMUser user : selectedUsers) {
            try {
                if (secretController != null) {
                    secretController.deleteSubjectSecrets(user.getUserId());
                }
                TeamManager.getInstance().getAdminController().deleteUser(user.getUserId());
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError("Error deleting user " + user.getUserId(), null, (Throwable)e);
            }
        }
        this.currentUser = null;
        this.fillDetailsPanel((SMUser)null);
        this.getObjectList().loadData();
    }

    private void changeUserActive() {
        try {
            boolean isActive = this.activeCheck.getSelection();
            TeamManager.getInstance().getAdminController().enableUser(this.currentUser.getUserId(), isActive, TeamManager.getInstance().getCurrentUserId(), "Disabled manually");
            this.currentUser.enableUser(isActive);
            this.getObjectList().getItemsViewer().refresh((Object)this.currentUser);
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Error changing user active status", null, (Throwable)e);
        }
    }

    private void changeUserRole() {
        try {
            String roleName = this.roleText.getText();
            TeamManager.getInstance().getAdminController().setUserAuthRole(this.currentUser.getUserId(), roleName);
            this.currentUser.setAuthRole(roleName);
            this.getObjectList().getItemsViewer().refresh((Object)this.currentUser);
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Error changing user role", null, (Throwable)e);
        }
    }
}

