/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.team.ui.admin;

import com.dbeaver.team.model.TeamManager;
import com.dbeaver.team.ui.admin.ObjectListFolder;
import com.dbeaver.team.ui.admin.SelectProjectDialog;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbenchPart;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.rm.RMProject;
import org.jkiss.dbeaver.model.security.SMObjectPermissionsGrant;
import org.jkiss.dbeaver.model.security.SMObjectType;
import org.jkiss.dbeaver.model.security.SMPropertyDescriptor;
import org.jkiss.dbeaver.model.security.SMSubjectType;
import org.jkiss.dbeaver.model.security.user.SMSubject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ListContentProvider;
import org.jkiss.utils.CommonUtils;

abstract class SubjectsFolder<SUBJECT_TYPE extends SMSubject>
extends ObjectListFolder<SUBJECT_TYPE> {
    private TableViewer projectsViewer;
    private final Map<String, MetaInfo> metaFields = new HashMap<String, MetaInfo>();
    private Font italicFont;
    private Font boldFont;
    private Button applyButton;
    private ToolItem addSubjectItem;

    public SubjectsFolder(IWorkbenchPart part) {
        super(part);
    }

    @NotNull
    protected abstract SMSubjectType getSubjectType();

    protected abstract SMSubject getCurrentSubject();

    protected void createMetaParams(Composite panel) {
        Group paramsPanel = UIUtils.createControlGroup((Composite)panel, (String)"Parameters", (int)2, (int)768, (int)-1);
        paramsPanel.setLayoutData((Object)new GridData(770));
        try {
            SMPropertyDescriptor[] sMPropertyDescriptorArray = TeamManager.getInstance().getMetaParametersBySubjectType(this.getSubjectType());
            int n = sMPropertyDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                SMPropertyDescriptor metaProp = sMPropertyDescriptorArray[n2];
                Text metaText = UIUtils.createLabelText((Composite)paramsPanel, (String)metaProp.getDisplayName(), null, (int)2048);
                metaText.setMessage(CommonUtils.notEmpty((String)metaProp.getDescription()));
                metaText.setToolTipText(CommonUtils.notEmpty((String)metaProp.getDescription()));
                this.metaFields.put(metaProp.getId(), new MetaInfo(metaProp, metaText));
                ++n2;
            }
            this.applyButton = UIUtils.createPushButton((Composite)paramsPanel, (String)"Apply changes", null, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SubjectsFolder.this.changeSubjectMetas();
                }
            });
            this.applyButton.setEnabled(false);
            for (MetaInfo mi : this.metaFields.values()) {
                mi.editor.addModifyListener(e -> this.applyButton.setEnabled(true));
            }
        }
        catch (DBException e2) {
            DBWorkbench.getPlatformUI().showError("Error reading meta parameters", null, (Throwable)e2);
        }
    }

    protected void loadMetaParams(@Nullable SMSubject object) {
        for (MetaInfo metaInfo : this.metaFields.values()) {
            metaInfo.editor.setText("");
            metaInfo.editor.setEnabled(object != null);
        }
        if (object != null) {
            for (Map.Entry entry : object.getMetaParameters().entrySet()) {
                MetaInfo metaInfo = this.metaFields.get(entry.getKey());
                if (metaInfo == null) continue;
                metaInfo.editor.setText(CommonUtils.notEmpty((String)((String)entry.getValue())));
            }
        }
        this.applyButton.setEnabled(false);
    }

    protected void createProjectsPanel(Composite panel) {
        Group projectsPanel = UIUtils.createControlGroup((Composite)panel, (String)"Projects", (int)1, (int)768, (int)-1);
        projectsPanel.setLayoutData((Object)new GridData(1808));
        this.projectsViewer = new TableViewer((Composite)projectsPanel, 2);
        this.projectsViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.projectsViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.projectsViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                SMObjectPermissionsGrant grant = (SMObjectPermissionsGrant)element;
                Object projectId = grant.getObjectPermissions().getObjectId().substring(2);
                if (!grant.getSubjectId().equals(SubjectsFolder.this.getCurrentSubject().getSubjectId())) {
                    projectId = (String)projectId + " (" + grant.getSubjectId() + ")";
                }
                return projectId;
            }

            public Image getImage(Object element) {
                return DBeaverIcons.getImage((DBPImage)DBIcon.PROJECT);
            }

            public Font getFont(Object element) {
                SMObjectPermissionsGrant grant = (SMObjectPermissionsGrant)element;
                if (SubjectsFolder.this.getSubjectType() == SMSubjectType.team || !grant.getSubjectId().equals(SubjectsFolder.this.getCurrentSubject().getSubjectId())) {
                    return super.getFont(element);
                }
                return SubjectsFolder.this.boldFont;
            }
        });
        this.italicFont = UIUtils.modifyFont((Font)this.projectsViewer.getTable().getFont(), (int)2);
        this.boldFont = UIUtils.modifyFont((Font)this.projectsViewer.getTable().getFont(), (int)1);
        this.projectsViewer.getTable().addDisposeListener(e -> {
            this.italicFont.dispose();
            this.boldFont.dispose();
        });
        ToolBar teamToolbar = new ToolBar((Composite)projectsPanel, 131328);
        this.addSubjectItem = UIUtils.createToolItem((ToolBar)teamToolbar, (String)"Add", (String)"Add", (DBPImage)UIIcon.ADD, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SubjectsFolder.this.addProjectAccess();
            }
        });
        ToolItem removeSubjectItem = UIUtils.createToolItem((ToolBar)teamToolbar, (String)"Remove", (String)"Remove", (DBPImage)UIIcon.DELETE, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SubjectsFolder.this.removeProjectAccess(SubjectsFolder.this.projectsViewer.getStructuredSelection().toList());
            }
        });
        removeSubjectItem.setEnabled(false);
        this.projectsViewer.addSelectionChangedListener(event -> {
            List selectedProjectGrants = this.projectsViewer.getStructuredSelection().toList();
            for (SMObjectPermissionsGrant grant : selectedProjectGrants) {
                if (grant.getSubjectId().equals(this.getCurrentSubject().getSubjectId())) continue;
                removeSubjectItem.setEnabled(false);
                return;
            }
            removeSubjectItem.setEnabled(!selectedProjectGrants.isEmpty());
        });
    }

    protected void loadProjectsDetails(@Nullable SMSubject object) {
        this.projectsViewer.setInput(Collections.emptyList());
        this.addSubjectItem.setEnabled(object != null);
        if (object != null) {
            try {
                this.projectsViewer.setInput(TeamManager.getInstance().getSubjectProjectGrants(object));
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError("Error reading projects information", null, (Throwable)e);
            }
        }
    }

    private void addProjectAccess() {
        SelectProjectDialog dialog = new SelectProjectDialog(this.projectsViewer.getTable().getShell());
        dialog.setExcludeProjects(((List)this.projectsViewer.getInput()).stream().map(g -> g.getObjectPermissions().getObjectId()).collect(Collectors.toList()));
        if (dialog.open() == 0) {
            List<RMProject> selectedProjects = dialog.getSelectedProjects();
            for (RMProject project : selectedProjects) {
                try {
                    List projectGrants = TeamManager.getInstance().getAdminController().getObjectPermissionGrants(project.getId(), SMObjectType.project);
                    Set newSubjectIds = projectGrants.stream().map(SMObjectPermissionsGrant::getSubjectId).collect(Collectors.toSet());
                    newSubjectIds.add(this.getCurrentSubject().getSubjectId());
                    TeamManager.getInstance().getAdminController().setObjectPermissions(Collections.singleton(project.getId()), SMObjectType.project, newSubjectIds, Collections.singleton("project-resource-view"), TeamManager.getInstance().getCurrentUserId());
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError("Error changing projects permissions", null, (Throwable)e);
                }
            }
            this.loadProjectsDetails(this.getCurrentSubject());
        }
    }

    private void removeProjectAccess(List<SMObjectPermissionsGrant> projectGrants) {
        List projectIds = projectGrants.stream().map(g -> g.getObjectPermissions().getObjectId()).collect(Collectors.toList());
        if (!UIUtils.confirmAction((Shell)this.projectsViewer.getTable().getShell(), (String)"Remove project", (String)("Are you sure you want to remove project(s) '" + String.join((CharSequence)" ", projectIds) + "' access?"))) {
            return;
        }
        try {
            TeamManager.getInstance().getAdminController().setObjectPermissions(new HashSet(projectIds), SMObjectType.project, Collections.singleton(this.getCurrentSubject().getSubjectId()), Collections.emptySet(), TeamManager.getInstance().getCurrentUserId());
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Error changing projects permissions", null, (Throwable)e);
        }
        this.loadProjectsDetails(this.getCurrentSubject());
    }

    private void changeSubjectMetas() {
        try {
            LinkedHashMap<String, String> metaParams = new LinkedHashMap<String, String>();
            for (Map.Entry<String, MetaInfo> entry : this.metaFields.entrySet()) {
                metaParams.put(entry.getKey(), entry.getValue().editor.getText());
            }
            TeamManager.getInstance().getAdminController().setSubjectMetas(this.getCurrentSubject().getSubjectId(), metaParams);
            for (Map.Entry<String, MetaInfo> entry : metaParams.entrySet()) {
                this.getCurrentSubject().setMetaParameter(entry.getKey(), (String)((Object)entry.getValue()));
            }
            this.applyButton.setEnabled(false);
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Error changing subject meta parameters", null, (Throwable)e);
        }
    }

    private static class MetaInfo {
        private final SMPropertyDescriptor metaProp;
        private final Text editor;

        public MetaInfo(SMPropertyDescriptor metaProp, Text editor) {
            this.metaProp = metaProp;
            this.editor = editor;
        }
    }
}

