/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.team.ui.admin;

import com.dbeaver.remote.workspace.RemoteProjectImpl;
import com.dbeaver.team.model.TeamManager;
import com.dbeaver.team.ui.admin.ObjectListFolder;
import com.dbeaver.team.ui.admin.SelectSubjectDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbenchPart;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.rm.RMProject;
import org.jkiss.dbeaver.model.rm.RMProjectType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.security.SMObjectPermissionsGrant;
import org.jkiss.dbeaver.model.security.SMObjectType;
import org.jkiss.dbeaver.model.security.SMSubjectType;
import org.jkiss.dbeaver.model.security.user.SMSubject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ListContentProvider;
import org.jkiss.utils.CommonUtils;

public class ProjectsFolder
extends ObjectListFolder<RMProject> {
    private static final Log log = Log.getLog(ProjectsFolder.class);
    private Text projectId;
    private Text projectName;
    private Text projectDescription;
    private TableViewer accessViewer;
    private RMProject currentProject;
    private List<SMObjectPermissionsGrant> projectGrants;

    public ProjectsFolder(IWorkbenchPart part) {
        super(part);
    }

    public void setCurrentProject(@NotNull RemoteProjectImpl remoteProject) {
        this.currentProject = remoteProject.getRMProject();
    }

    @Override
    protected Collection<RMProject> loadObjects(DBRProgressMonitor monitor) throws DBException {
        ArrayList<RMProject> projects = new ArrayList<RMProject>(TeamManager.getInstance().getProjects(null));
        projects.sort((o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
        return projects;
    }

    @Override
    protected DBPImage getObjectImage(RMProject item) {
        return DBIcon.PROJECT;
    }

    @Override
    protected boolean isObjectMatches(RMProject element, String searchString) {
        return element.getDisplayName().toUpperCase().contains(searchString.toUpperCase());
    }

    @Override
    public void createDetailsPanel(Composite parent) {
        Composite main = UIUtils.createComposite((Composite)parent, (int)1);
        main.setLayoutData((Object)new GridData(1808));
        Group infoPanel = UIUtils.createControlGroup((Composite)main, (String)"Information", (int)2, (int)768, (int)-1);
        infoPanel.setLayoutData((Object)new GridData(770));
        this.projectId = UIUtils.createLabelText((Composite)infoPanel, (String)"Project ID", null, (int)2056);
        this.projectName = UIUtils.createLabelText((Composite)infoPanel, (String)"Project name", null, (int)2056);
        this.projectDescription = UIUtils.createLabelText((Composite)infoPanel, (String)"Description", null, (int)2056);
        Group subjectsPanel = UIUtils.createControlGroup((Composite)main, (String)"Access", (int)1, (int)768, (int)-1);
        subjectsPanel.setLayoutData((Object)new GridData(1808));
        this.accessViewer = new TableViewer((Composite)subjectsPanel, 2);
        this.accessViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.accessViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.accessViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((SMObjectPermissionsGrant)element).getSubjectId();
            }

            public Image getImage(Object element) {
                if (((SMObjectPermissionsGrant)element).getSubjectType() == SMSubjectType.user) {
                    return DBeaverIcons.getImage((DBPImage)DBIcon.TREE_USER);
                }
                return DBeaverIcons.getImage((DBPImage)DBIcon.TREE_USER_GROUP);
            }
        });
        ToolBar teamToolbar = new ToolBar((Composite)subjectsPanel, 131328);
        UIUtils.createToolItem((ToolBar)teamToolbar, (String)"Add", (String)"Add", (DBPImage)UIIcon.ADD, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectsFolder.this.addSubjectAccess();
            }
        });
        ToolItem removeSubjectItem = UIUtils.createToolItem((ToolBar)teamToolbar, (String)"Remove", (String)"Remove", (DBPImage)UIIcon.DELETE, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List grants = ProjectsFolder.this.accessViewer.getStructuredSelection().toList();
                ProjectsFolder.this.removeSubjectAccess(grants.stream().map(SMObjectPermissionsGrant::getSubjectId).collect(Collectors.toList()));
            }
        });
        removeSubjectItem.setEnabled(false);
        this.accessViewer.addSelectionChangedListener(event -> removeSubjectItem.setEnabled(!event.getSelection().isEmpty()));
    }

    @Override
    public void fillDetailsPanel(RMProject object) {
        this.currentProject = object;
        this.projectId.setText(object.getId());
        this.projectName.setText(object.getName());
        this.projectDescription.setText(CommonUtils.notEmpty((String)object.getDescription()));
        this.accessViewer.setInput(Collections.emptyList());
        try {
            this.projectGrants = TeamManager.getInstance().getProjectGrants(object.getId());
            this.accessViewer.setInput(this.projectGrants);
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Error reading projects information", null, (Throwable)e);
        }
    }

    private void addSubjectAccess() {
        if (this.currentProject.getType() != RMProjectType.SHARED) {
            UIUtils.showMessageBox((Shell)this.accessViewer.getTable().getShell(), (String)"Private project", (String)"You can not grant access to private project", (int)1);
            return;
        }
        SelectSubjectDialog dialog = new SelectSubjectDialog(this.accessViewer.getTable().getShell(), SelectSubjectDialog.SubjectType.ALL);
        dialog.setExcludeSubjects(this.projectGrants.stream().map(SMObjectPermissionsGrant::getSubjectId).collect(Collectors.toList()));
        if (dialog.open() == 0) {
            List<SMSubject> selectedSubjects = dialog.getSelectedSubjects();
            Set newSubjectIds = this.projectGrants.stream().map(SMObjectPermissionsGrant::getSubjectId).collect(Collectors.toSet());
            newSubjectIds.addAll(selectedSubjects.stream().map(SMSubject::getSubjectId).toList());
            try {
                TeamManager.getInstance().getAdminController().setObjectPermissions(Collections.singleton(this.currentProject.getId()), SMObjectType.project, newSubjectIds, Collections.singleton("project-resource-view"), TeamManager.getInstance().getCurrentUserId());
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError("Error changing projects permissions", null, (Throwable)e);
            }
            this.fillDetailsPanel(this.currentProject);
        }
    }

    private void removeSubjectAccess(List<String> subjectIds) {
        if (!UIUtils.confirmAction((Shell)this.accessViewer.getTable().getShell(), (String)"Remove access", (String)("Are you sure you want to remove project '" + this.currentProject.getDisplayName() + "' access from " + String.join((CharSequence)" ", subjectIds) + "?"))) {
            return;
        }
        try {
            TeamManager.getInstance().getAdminController().setObjectPermissions(Collections.singleton(this.currentProject.getId()), SMObjectType.project, new HashSet<String>(subjectIds), Collections.emptySet(), TeamManager.getInstance().getCurrentUserId());
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Error changing projects permissions", null, (Throwable)e);
        }
        this.fillDetailsPanel(this.currentProject);
    }
}

