/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.team.ui.admin;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.AbstractLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadVisualizer;
import org.jkiss.dbeaver.ui.ContextSearchAction;
import org.jkiss.dbeaver.ui.ISearchContextProvider;
import org.jkiss.dbeaver.ui.ISearchExecutor;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomSashForm;
import org.jkiss.dbeaver.ui.controls.ListContentProvider;
import org.jkiss.dbeaver.ui.controls.folders.ITabbedFolder;
import org.jkiss.dbeaver.ui.navigator.itemlist.DatabaseObjectListControl;
import org.jkiss.dbeaver.ui.navigator.itemlist.ObjectListControl;

abstract class ObjectListFolder<OBJECT_TYPE extends DBPObject>
implements ITabbedFolder {
    @Nullable
    private final IWorkbenchPart part;
    private ObjectListControl<OBJECT_TYPE> objectList;
    private boolean activated;
    private boolean detailsCreated;

    ObjectListFolder(@Nullable IWorkbenchPart part) {
        this.part = part;
    }

    protected ObjectListControl<OBJECT_TYPE> getObjectList() {
        return this.objectList;
    }

    public void createControl(Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        CustomSashForm sashMain = new CustomSashForm(composite, UIUtils.checkSashStyle((int)66048));
        sashMain.setLayoutData((Object)new GridData(1808));
        Composite listPanel = UIUtils.createComposite((Composite)sashMain, (int)1);
        this.objectList = new AdminObjectListControl(listPanel, (IWorkbenchSite)(this.part == null ? null : this.part.getSite()));
        this.objectList.setLayoutData((Object)new GridData(1808));
        this.objectList.createProgressPanel(listPanel);
        Composite detailsPanel = new Composite((Composite)sashMain, 0);
        detailsPanel.setLayout((Layout)new GridLayout(1, true));
        this.objectList.getItemsViewer().addSelectionChangedListener(event -> {
            IStructuredSelection ss = this.objectList.getItemsViewer().getStructuredSelection();
            if (!ss.isEmpty()) {
                if (!this.detailsCreated) {
                    this.createDetailsPanel(detailsPanel);
                    detailsPanel.layout(true, true);
                    this.detailsCreated = true;
                }
                this.fillDetailsPanel((DBPObject)ss.getFirstElement());
            }
        });
    }

    public void aboutToBeShown() {
        IStructuredSelection ss;
        if (!this.activated) {
            this.objectList.loadData();
            this.activated = true;
        }
        if (!(ss = this.objectList.getItemsViewer().getStructuredSelection()).isEmpty()) {
            this.fillDetailsPanel((DBPObject)ss.getFirstElement());
        }
    }

    public void aboutToBeHidden() {
    }

    public void setFocus() {
        this.objectList.setFocus();
    }

    public void dispose() {
    }

    protected Collection<OBJECT_TYPE> loadObjects(DBRProgressMonitor monitor) throws DBException {
        return Collections.emptyList();
    }

    protected abstract DBPImage getObjectImage(OBJECT_TYPE var1);

    protected void contributeToToolbar(IContributionManager contributionManager) {
    }

    protected abstract boolean isObjectMatches(OBJECT_TYPE var1, String var2);

    public void createDetailsPanel(Composite parent) {
    }

    public void fillDetailsPanel(OBJECT_TYPE object) {
    }

    private class AdminObjectListControl
    extends DatabaseObjectListControl<OBJECT_TYPE> {
        private final ObjectSearcher searcher;

        public AdminObjectListControl(Composite parent, IWorkbenchSite site) {
            super(parent, 0x10000000, site, (IContentProvider)new ListContentProvider());
            this.searcher = new ObjectSearcher();
        }

        protected ISearchExecutor getSearchRunner() {
            return this.searcher;
        }

        @NotNull
        protected String getListConfigId(List<Class<?>> classList) {
            return ((Object)((Object)this)).getClass().getName();
        }

        @Nullable
        protected DBPImage getObjectImage(OBJECT_TYPE item) {
            return ObjectListFolder.this.getObjectImage(item);
        }

        protected LoadingJob<Collection<OBJECT_TYPE>> createLoadService(boolean forUpdate) {
            return LoadingJob.createService((ILoadService)new ObjectsLoadService(), (ILoadVisualizer)new ObjectListControl.ObjectsLoadVisualizer((ObjectListControl)this));
        }

        public void fillCustomActions(IContributionManager contributionManager) {
            super.fillCustomActions(contributionManager);
            ObjectListFolder.this.contributeToToolbar(contributionManager);
            this.addColumnConfigAction(contributionManager);
        }

        protected void addSearchAction(IContributionManager contributionManager) {
            contributionManager.add((IAction)new ContextSearchAction((ISearchContextProvider)this, ISearchContextProvider.SearchType.NONE));
        }
    }

    private class ObjectSearcher
    implements ISearchExecutor {
        private ObjectSearcher() {
        }

        public boolean performSearch(final String searchString, int options) {
            try {
                ViewerFilter searchFilter = new ViewerFilter(){

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        return ObjectListFolder.this.isObjectMatches((DBPObject)element, searchString);
                    }
                };
                ObjectListFolder.this.objectList.getItemsViewer().setFilters(new ViewerFilter[]{searchFilter});
                return true;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                return false;
            }
        }

        public void cancelSearch() {
            ObjectListFolder.this.objectList.getItemsViewer().setFilters(new ViewerFilter[0]);
        }
    }

    private class ObjectsLoadService
    extends AbstractLoadService<Collection<OBJECT_TYPE>> {
        protected ObjectsLoadService() {
            super("Admin objects load");
        }

        public Collection<OBJECT_TYPE> evaluate(@NotNull DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                return ObjectListFolder.this.loadObjects(monitor);
            }
            catch (Throwable ex) {
                throw new InvocationTargetException(ex);
            }
        }

        public Object getFamily() {
            return ObjectsLoadService.class;
        }
    }
}

