/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.team.ui.admin;

import com.dbeaver.lm.api.LMRole;
import com.dbeaver.team.model.TeamManager;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.security.user.SMUser;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;

class CreateUserDialog
extends BaseDialog {
    private Text usernameText;
    private Combo roleText;
    private Button activeCheck;
    private Button localCheck;
    private SMUser newUser;

    public CreateUserDialog(Shell parentShell) {
        super(parentShell, "Create user", (DBPImage)DBIcon.TREE_USER);
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        Group infoPanel = UIUtils.createControlGroup((Composite)composite, (String)"User", (int)1, (int)1808, (int)-1);
        infoPanel.setLayoutData((Object)new GridData(1808));
        this.usernameText = UIUtils.createLabelText((Composite)infoPanel, (String)"Username", null, (int)2048);
        this.roleText = UIUtils.createLabelCombo((Composite)infoPanel, (String)"Role", (String)"User role", (int)2060);
        LMRole[] lMRoleArray = LMRole.values();
        int n = lMRoleArray.length;
        int n2 = 0;
        while (n2 < n) {
            LMRole lmRole = lMRoleArray[n2];
            this.roleText.add(lmRole.name());
            ++n2;
        }
        this.roleText.setText(LMRole.getDefaultRole().name());
        this.activeCheck = UIUtils.createCheckbox((Composite)infoPanel, (String)"Active", (String)"User is active", (boolean)true, (int)1);
        this.localCheck = UIUtils.createCheckbox((Composite)infoPanel, (String)"Local", (String)"Use local credentials", (boolean)true, (int)1);
        return composite;
    }

    protected void okPressed() {
        String username = this.usernameText.getText().toLowerCase();
        boolean isActive = this.activeCheck.getSelection();
        LMRole lmRole = LMRole.valueOf((String)this.roleText.getText());
        boolean isLocal = this.localCheck.getSelection();
        try {
            TeamManager.getInstance().getAdminController().createUser(username, Collections.emptyMap(), isActive, lmRole.name());
            if (isLocal) {
                LinkedHashMap<String, String> credentials = new LinkedHashMap<String, String>();
                credentials.put("user", username);
                TeamManager.getInstance().getAdminController().setUserCredentials(username, "local", credentials);
            }
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Error creating user", null, (Throwable)e);
            return;
        }
        this.newUser = new SMUser(username, isActive, lmRole.name());
        super.okPressed();
    }

    public SMUser getNewUser() {
        return this.newUser;
    }
}

