/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.team.shed;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.secret.DBSDefaultTeamProvider;
import org.jkiss.dbeaver.model.security.SMAdminController;
import org.jkiss.dbeaver.model.security.user.SMTeam;
import org.jkiss.dbeaver.model.task.DBTTaskScheduleConfiguration;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class RemoteSchedulerDialogConfigurator
implements IObjectPropertyConfigurator<DBTTaskScheduleConfiguration, DBTTaskScheduleConfiguration> {
    private static final Log log = Log.getLog(RemoteSchedulerDialogConfigurator.class);
    @Nullable
    private Combo secretCombo;
    private SMTeam[] teams;

    public void createControl(@NotNull Composite parent, DBTTaskScheduleConfiguration configuration, @NotNull Runnable propertyChangeListener) {
        SMAdminController adminController = (SMAdminController)DBUtils.getAdapter(SMAdminController.class, (Object)DBWorkbench.getPlatform().getWorkspace().getWorkspaceSession());
        if (adminController == null) {
            return;
        }
        Composite secretComp = UIUtils.createComposite((Composite)parent, (int)2);
        this.secretCombo = UIUtils.createLabelCombo((Composite)secretComp, (String)"Team Name", (int)12);
        this.secretCombo.setLayoutData((Object)new GridData(32));
        this.secretCombo.setEnabled(true);
        try {
            SMTeam[] sMTeamArray = this.teams = adminController.readAllTeams();
            int n = this.teams.length;
            int n2 = 0;
            while (n2 < n) {
                SMTeam team = sMTeamArray[n2];
                this.secretCombo.add(team.getTeamName());
                ++n2;
            }
        }
        catch (DBException e) {
            log.error((Object)"Error reading teams", (Throwable)e);
        }
        this.loadSettings(configuration);
    }

    public void loadSettings(@NotNull DBTTaskScheduleConfiguration configuration) {
        DBSDefaultTeamProvider teamProvider;
        if (this.secretCombo == null || this.teams == null) {
            return;
        }
        String selectedSecret = (String)configuration.properties.get("shared.credentials.default.subject");
        if (CommonUtils.isEmpty((String)selectedSecret) && (teamProvider = (DBSDefaultTeamProvider)DBUtils.getAdapter(DBSDefaultTeamProvider.class, (Object)DBWorkbench.getPlatform().getApplication())) != null) {
            selectedSecret = teamProvider.getDefaultTeamId();
        }
        if (CommonUtils.isEmpty((String)selectedSecret)) {
            this.secretCombo.select(0);
        } else {
            int i = 0;
            while (i < this.teams.length) {
                SMTeam team = this.teams[i];
                if (CommonUtils.equalObjects((Object)team.getTeamId(), (Object)selectedSecret)) {
                    this.secretCombo.select(i);
                }
                ++i;
            }
        }
    }

    public void saveSettings(@NotNull DBTTaskScheduleConfiguration configuration) {
        if (this.secretCombo != null) {
            int index = this.secretCombo.getSelectionIndex();
            if (index > 0 && this.teams != null) {
                configuration.properties.put("shared.credentials.default.subject", this.teams[index].getTeamId());
            } else {
                configuration.properties.remove("shared.credentials.default.subject");
            }
        }
    }

    public void resetSettings(@NotNull DBTTaskScheduleConfiguration configuration) {
        configuration.properties.remove("shared.credentials.default.subject");
        if (this.secretCombo != null) {
            this.secretCombo.select(0);
        }
    }

    public boolean isComplete() {
        return this.secretCombo != null && this.teams != null;
    }
}

