/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.team.model;

import com.dbeaver.model.auth.SMSessionRemote;
import com.dbeaver.remote.client.dc.DCClientConfiguration;
import com.dbeaver.remote.client.dc.DCRemoteSecurityController;
import com.dbeaver.remote.workspace.DesktopWorkspaceRemote;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.rm.RMController;
import org.jkiss.dbeaver.model.rm.RMProject;
import org.jkiss.dbeaver.model.rm.RMProjectType;
import org.jkiss.dbeaver.model.security.SMAdminController;
import org.jkiss.dbeaver.model.security.SMObjectPermissionsGrant;
import org.jkiss.dbeaver.model.security.SMObjectType;
import org.jkiss.dbeaver.model.security.SMPropertyDescriptor;
import org.jkiss.dbeaver.model.security.SMSubjectType;
import org.jkiss.dbeaver.model.security.user.SMSubject;
import org.jkiss.dbeaver.model.security.user.SMTeam;
import org.jkiss.dbeaver.model.security.user.SMUser;
import org.jkiss.dbeaver.model.security.user.SMUserFilter;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class TeamManager {
    private static final Log log = Log.getLog(TeamManager.class);
    private static TeamManager INSTANCE;
    private SMAdminController smController;
    private Map<SMSubjectType, SMPropertyDescriptor[]> metaParameters = new HashMap<SMSubjectType, SMPropertyDescriptor[]>();

    private TeamManager() {
    }

    public static synchronized TeamManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TeamManager();
        }
        return INSTANCE;
    }

    public String getCurrentUserId() {
        SMSession spaceSession = DBWorkbench.getPlatform().getWorkspace().getWorkspaceSession();
        SMSessionRemote sessionRemote = (SMSessionRemote)DBUtils.getAdapter(SMSessionRemote.class, (Object)spaceSession);
        return sessionRemote == null ? null : sessionRemote.getSessionPrincipal().getUserName();
    }

    public SMAdminController getAdminController() throws DBException {
        if (this.smController == null) {
            SMSession spaceSession = DBWorkbench.getPlatform().getWorkspace().getWorkspaceSession();
            SMSessionRemote sessionRemote = (SMSessionRemote)DBUtils.getAdapter(SMSessionRemote.class, (Object)spaceSession);
            if (sessionRemote == null) {
                throw new DBException("Team manager can work only in distributed product");
            }
            DCClientConfiguration clientConfig = DCClientConfiguration.builder((SMSessionRemote)sessionRemote).build();
            this.smController = new DCRemoteSecurityController(clientConfig);
        }
        return this.smController;
    }

    private RMController getResourceController() {
        return ((DesktopWorkspaceRemote)DBWorkbench.getPlatform().getWorkspace()).getResourceController();
    }

    public List<SMTeam> getAllTTeams() throws DBException {
        return Arrays.stream(this.getAdminController().readAllTeams()).sorted((o1, o2) -> o1.getTeamId().compareToIgnoreCase(o2.getTeamId())).collect(Collectors.toList());
    }

    public List<SMUser> getUsers(SMUserFilter filter) throws DBException {
        return Arrays.stream(this.getAdminController().findUsers(filter)).sorted(Comparator.comparing(SMUser::getUserId)).collect(Collectors.toList());
    }

    public List<String> getUserLinkedProviders(String userID) throws DBException {
        return Arrays.stream(this.getAdminController().getUserLinkedProviders(userID)).collect(Collectors.toList());
    }

    public Collection<RMProject> getProjects(String projectNameMask) throws DBException {
        return Arrays.stream(this.getResourceController().listAccessibleProjects()).sorted((o1, o2) -> o1.getId().compareToIgnoreCase(o2.getId())).collect(Collectors.toList());
    }

    public List<String> getTeamUsers(SMTeam team) throws DBException {
        return Arrays.stream(this.getAdminController().getTeamMembers(team.getTeamId())).sorted(String::compareToIgnoreCase).collect(Collectors.toList());
    }

    public List<SMObjectPermissionsGrant> getSubjectProjectGrants(SMSubject subject) throws DBException {
        return this.getAdminController().getSubjectObjectPermissionGrants(subject.getSubjectId(), SMObjectType.project).stream().filter(opg -> opg.getObjectPermissions().getObjectId().startsWith(RMProjectType.SHARED.getPrefix() + "_")).sorted((o1, o2) -> o1.getObjectPermissions().getObjectId().compareToIgnoreCase(o2.getObjectPermissions().getObjectId())).collect(Collectors.toList());
    }

    public List<SMObjectPermissionsGrant> getProjectGrants(String projectID) throws DBException {
        return this.getAdminController().getObjectPermissionGrants(projectID, SMObjectType.project);
    }

    public SMPropertyDescriptor[] getMetaParametersBySubjectType(SMSubjectType subjectType) throws DBException {
        SMPropertyDescriptor[] props = this.metaParameters.get(subjectType);
        if (props == null) {
            props = this.getAdminController().getMetaParametersBySubjectType(subjectType);
            this.metaParameters.put(subjectType, props);
        }
        return props;
    }
}

