/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.bucket;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.util.ReactorOps;
import com.couchbase.client.java.AsyncUtils;
import com.couchbase.client.java.manager.bucket.AsyncBucketManager;
import com.couchbase.client.java.manager.bucket.BucketSettings;
import com.couchbase.client.java.manager.bucket.CreateBucketOptions;
import com.couchbase.client.java.manager.bucket.DropBucketOptions;
import com.couchbase.client.java.manager.bucket.FlushBucketOptions;
import com.couchbase.client.java.manager.bucket.GetAllBucketOptions;
import com.couchbase.client.java.manager.bucket.GetBucketOptions;
import com.couchbase.client.java.manager.bucket.ReactiveBucketManager;
import com.couchbase.client.java.manager.bucket.UpdateBucketOptions;
import java.util.Map;
import java.util.Objects;

public class BucketManager {
    private final AsyncBucketManager async;
    private final ReactiveBucketManager reactive;

    @Stability.Internal
    public BucketManager(ReactorOps reactor, AsyncBucketManager async) {
        this.async = Objects.requireNonNull(async);
        this.reactive = new ReactiveBucketManager(reactor, async);
    }

    public AsyncBucketManager async() {
        return this.async;
    }

    public ReactiveBucketManager reactive() {
        return this.reactive;
    }

    public void createBucket(BucketSettings settings) {
        AsyncUtils.block(this.async.createBucket(settings));
    }

    public void createBucket(BucketSettings settings, CreateBucketOptions options) {
        AsyncUtils.block(this.async.createBucket(settings, options));
    }

    public void updateBucket(BucketSettings settings) {
        AsyncUtils.block(this.async.updateBucket(settings));
    }

    public void updateBucket(BucketSettings settings, UpdateBucketOptions options) {
        AsyncUtils.block(this.async.updateBucket(settings, options));
    }

    public void dropBucket(String bucketName) {
        AsyncUtils.block(this.async.dropBucket(bucketName));
    }

    public void dropBucket(String bucketName, DropBucketOptions options) {
        AsyncUtils.block(this.async.dropBucket(bucketName, options));
    }

    public BucketSettings getBucket(String bucketName) {
        return AsyncUtils.block(this.async.getBucket(bucketName));
    }

    public BucketSettings getBucket(String bucketName, GetBucketOptions options) {
        return AsyncUtils.block(this.async.getBucket(bucketName, options));
    }

    public Map<String, BucketSettings> getAllBuckets() {
        return AsyncUtils.block(this.async.getAllBuckets());
    }

    public Map<String, BucketSettings> getAllBuckets(GetAllBucketOptions options) {
        return AsyncUtils.block(this.async.getAllBuckets(options));
    }

    public void flushBucket(String bucketName) {
        AsyncUtils.block(this.async.flushBucket(bucketName));
    }

    public void flushBucket(String bucketName, FlushBucketOptions options) {
        AsyncUtils.block(this.async.flushBucket(bucketName, options));
    }
}

