/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mssql.model;

import com.dbeaver.db.mssql.model.SQLServerJob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class SQLServerDataSourceExt
extends SQLServerDataSource {
    private final JobCache jobCache = new JobCache();

    public SQLServerDataSourceExt(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        super(monitor, container);
    }

    @Association
    @NotNull
    public List<SQLServerJob> getJobs(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.jobCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.jobCache.clearCache();
        return super.refreshObject(monitor);
    }

    private static class JobCache
    extends JDBCObjectCache<SQLServerDataSource, SQLServerJob> {
        private JobCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull SQLServerDataSource dataSource) throws SQLException {
            return session.prepareStatement("SELECT j.*, c.name AS category_name, SUSER_SNAME(j.owner_sid) AS owner\nFROM msdb.dbo.sysjobs j\nJOIN msdb.dbo.syscategories c ON c.category_id = j.category_id");
        }

        @Nullable
        protected SQLServerJob fetchObject(@NotNull JDBCSession session, @NotNull SQLServerDataSource dataSource, @NotNull JDBCResultSet resultSet) {
            return new SQLServerJob(dataSource, (ResultSet)resultSet);
        }
    }
}

